
int defaultMovingType = 0;

boolean neonActive = false;

class Halo {
  ArrayList points = new ArrayList();
  int fadeInLength = 0;
  int fadeOutLength = 0;
  int inMs = 0;
  int outMs = 0;
  int blur = 3;
  int col = 0;
  int movingType = defaultMovingType;
  // 0=perc vibre 1=defile grandit 2=rond 3=sinus 4=rond vibre

    Halo() {
  }

  int firstAppear() {
    if ((movingType==2 || movingType==4) && points.size()>1) return floor(((PVector)points.get(0)).x - dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y));
    int result=-1;
    for (int i=0;i<points.size();i++) {
      if (((PVector)points.get(i)).x < result || result==-1) result = floor(((PVector)points.get(i)).x);
    }
    return result;
  }

  int lastAppear() {
    if ((movingType==2 || movingType==4) && points.size()>1) return floor(((PVector)points.get(0)).x + dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y));
    int result=-1;
    for (int i=0;i<points.size();i++) {
      if (((PVector)points.get(i)).x > result || result==-1) result = floor(((PVector)points.get(i)).x);
    }
    return result;
  }

  void display() {
    stroke(0xFF);
    fill(0x80, 0x80);
    if (mouseIn()) fill(0xA0, 0xC0, 0xC0, 0x80);
    if (movingType==0 || movingType==1 || movingType==3) {
      beginShape();
      for (int i=0;i<points.size();i++) {
        vertex(((PVector)points.get(i)).x, ((PVector)points.get(i)).y);
      }
      if (points.size()>0) vertex(((PVector)points.get(0)).x, ((PVector)points.get(0)).y);
      endShape();
    }
    if (movingType==2 || movingType==4) {
      if (points.size() > 1) {
        float d = dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y)*2;
        ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, d, d);
      } 
      else if (points.size() == 1) {
        ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, 5, 5);
      }
    }
  }

  boolean mouseIn() {
    float y = mouseY;
    float x = mouseX;
    if (movingType!=2 && movingType!=4) {
      float[] y2 = new float[points.size()];
      float[] x2 = new float[points.size()];    
      for (int i=0;i<points.size();i++) {
        x2[i]=((PVector)points.get(i)).x;
        y2[i]=((PVector)points.get(i)).y;
      }
      int i, j, c = 0;
      for (i = 0, j = x2.length-1; i < x2.length; j = i++) {  
        if ((((y2[i] <= y) && (y < y2[j])) || ((y2[j] <= y) && (y < y2[i]))) && (x < (x2[j] - x2[i]) * (y - y2[i]) / (y2[j] - y2[i]) + x2[i])) c = (c+1)%2;
      }  
      return c==1;
    }
    else {
      if (points.size()>1) {
        if (dist(x, y, ((PVector)points.get(0)).x, ((PVector)points.get(0)).y) <=
          dist(((PVector)points.get(1)).x, ((PVector)points.get(1)).y, ((PVector)points.get(0)).x, ((PVector)points.get(0)).y)) {
          return true;
        }
      }
      return false;
    }
  }

  String[] dataToExport() {
    String[] result = new String[0];
    return result;
  }

  void updateOptionalValues() {
    fadeInLength = Integer.parseInt(inputBox.answer[0]);
    fadeOutLength = Integer.parseInt(inputBox.answer[1]);
    inMs = Integer.parseInt(inputBox.answer[2]);
    outMs = Integer.parseInt(inputBox.answer[3]);
    blur = Integer.parseInt(inputBox.answer[4]);
    col = Integer.parseInt(inputBox.answer[5]);
    movingType = Integer.parseInt(inputBox.answer[6]);
  }

  void addPoint(float x, float y) {
    if ((movingType==2 || movingType==4) && points.size()==2) {
      points.set(1, new PVector(x, y));
    } 
    else {
      points.add(new PVector(x, y));
    }
  }

  void removeLastPoint() {
    if (points.size()>0) {
      points.remove(points.size()-1);
    }
  }

  String[] getExportData() {
    String[] result = new String[11+points.size()*2];
    int i=0;
    result[i++]="<Halo>";
    result[i++] = "fadeInLength=" + fadeInLength;
    result[i++] = "fadeOutLength=" + fadeOutLength;
    result[i++] = "inMs=" + inMs;
    result[i++] = "outMs=" + outMs;
    result[i++] = "blur=" + blur;
    result[i++] = "col=" + col;
    result[i++] = "movingType=" + movingType;
    result[i++]="<Points>";
    for (int j=0;j<points.size();j++) {
      result[i++]= "x=" + ((PVector)points.get(j)).x;
      result[i++]= "y=" + ((PVector)points.get(j)).y;
    }
    result[i++]="</Points>";    
    result[i++]="</Halo>";
    return result;
  }

  void displayForFrame(int f) {
    int inFrame = floor((float)inMs * fRate / 1000);
    int outFrame = floor((float)outMs * fRate / 1000);
    float playingX = (float)(f-inFrame) / (outFrame - inFrame) * (lastAppear() - firstAppear()) + firstAppear();    
    float fadeInLengthFrames = (float)fadeInLength * fRate / 1000;
    float fadeOutLengthFrames = (float)fadeOutLength * fRate / 1000;
    float transpLevel = 1;
    transpLevel *= constrain(((float)f-inFrame)/(fadeInLengthFrames+1), 0, 1);
    transpLevel *= 1 - constrain(((float)f-outFrame)/(fadeOutLengthFrames+1), 0, 1)*2/3;
    transpLevel /= (blur/3)+1;
    float blurAction=constrain(blur-((float)constrain(f-outFrame, 0, blur*3))/3, 0, blur);
    noStroke();
    fill(0xFF, transpLevel * 0xFF);
    for (int b=0;b<blur;b++) {
      beginShape();
      for (int i=0;i<points.size();i++) {
        float thisX = ((PVector)points.get(i)).x;
        float thisY = ((PVector)points.get(i)).y;
        if (movingType==0) {
          thisX+=random(-blurAction, blurAction);
          thisY+=random(-blurAction, blurAction);
        }
        if (movingType==1 || movingType==3) {
          if (thisX > playingX) {
            thisX = playingX;
          }
        }
        if (movingType != 2 && movingType!=4) vertex(thisX, thisY);
      }
      endShape();
    }
    if (movingType==2) {
      if (points.size() > 1) {
        for (int b=0;b<blur;b++) {        
          float d = dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y)*2;
          ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, d-constrain(d-(f-inFrame), 0, d)-b, d-constrain(d-(f-inFrame), 0, d)-b);
        }
      }
    }
    if (movingType==4) {
      if (points.size() > 1) {
        for (int b=0;b<blur;b++) {      
          float d = dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y)*2;
          float vibre = sin((float)f*2+d)*max(outFrame+fRate-f, 0)*(float)d/20;
          ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y + vibre, d-constrain(d-(f-inFrame), 0, d)-b, d-constrain(d-(f-inFrame), 0, d)-b);
        }
      }
    }    
    // neon
    if (neonActive) {
      for (int b=0;b<blur;b++) {
        strokeWeight(b);
        if (f > inFrame) {
          if (col==-1) stroke(random(0xFF), 0xFF, 0xFF, constrain(0xA0-(outFrame-f)*50, 0, 0xF0)/blur);
          else stroke((col)%0xFF, 0xFF, 0xFF, constrain(0xA0-(outFrame-f)*50, 0, 0xF0)/blur);
          if (f > outFrame) stroke((col)%0xFF, 0xFF, 0xFF-(f-outFrame), constrain(0xFF-(outFrame-f)*50, 0, 0xFF));
          noFill();
          PVector middle = new PVector();
          for (int i=0;i<points.size();i++) {
            middle.x+=((PVector)points.get(i)).x/points.size();
            middle.y+=((PVector)points.get(i)).y/points.size();
          }
          if (movingType == 0 || movingType == 1) {
            beginShape();
            for (int i=0;i<points.size();i++) {
              float thisX = ((PVector)points.get(i)).x;
              float thisY = ((PVector)points.get(i)).y;
              thisX += (thisX-middle.x)*max(0, outFrame-f);
              thisY += (thisY-middle.y)*max(0, outFrame-f);
              vertex(thisX, thisY);
            }
            if (points.size()>0) {
              float thisX = ((PVector)points.get(0)).x;
              float thisY = ((PVector)points.get(0)).y;
              thisX += (thisX-middle.x)*max(0, outFrame-f);
              thisY += (thisY-middle.y)*max(0, outFrame-f);        
              vertex(thisX, thisY);
            }
            endShape();
          }
        }
        if (movingType==3) {
          for (int i=0;i<points.size();i++) {
            float thisX = ((PVector)points.get(i)).x;
            float thisY = ((PVector)points.get(i)).y;
            float thisX2 = ((PVector)points.get((i+1)%points.size())).x;
            float thisY2 = ((PVector)points.get((i+1)%points.size())).y;        
            if (thisX<playingX && thisX2<playingX) line(thisX, thisY, thisX2, thisY2);
          }
        }
        if (movingType==2) {
          if (points.size() > 1) {
            float d = dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y)*2;
            ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, d*max(1, outFrame-f), d*max(1, outFrame-f));
          }
        }
        if (movingType==4) {
          if (points.size() > 1) {
            float d = dist(((PVector)points.get(0)).x, ((PVector)points.get(0)).y, ((PVector)points.get(1)).x, ((PVector)points.get(1)).y)*2;
            float vibre = sin((float)f*2+d)*max(outFrame+fRate-f, 0)*(float)d/20;
            ellipse(((PVector)points.get(0)).x, ((PVector)points.get(0)).y+vibre, d*max(1, outFrame-f), d*max(1, outFrame-f));
          }
        }
      }
    }
    strokeWeight(1);
  }

  void spreadColor(int mode) {
    if (mode==0) {
      float middleY=0;
      for (int i=0;i<points.size();i++) {
        middleY+=((PVector)points.get(i)).y/points.size();
      }
      col=floor(middleY*0xFF/height);
    }
  }
}

