/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.MappedByteBufferOutputStream;
import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.common.Debug;

public class MappedByteBufferInputStream
extends InputStream {
    private static final FileResizeOp NoFileResize = new FileResizeOp(){

        @Override
        public void setLength(long l) throws IOException {
            throw new IOException("file size change not supported");
        }
    };
    public static final int DEFAULT_SLICE_SHIFT;
    static final boolean DEBUG;
    private final int sliceShift;
    private final FileChannel fc;
    private final FileChannel.MapMode mmode;
    private FileResizeOp fileResizeOp = NoFileResize;
    private int sliceCount;
    private ByteBuffer[] slices;
    private WeakReference<ByteBuffer>[] slices2GC;
    private long totalSize;
    private int slicesEntries;
    private int slices2GCEntries;
    private boolean synchronous;
    private int refCount;
    private Method mbbCleaner;
    private Method cClean;
    private boolean cleanerInit;
    private boolean hasCleaner;
    private CacheMode cmode;
    private int sliceIdx;
    private long mark;

    final void dbgDump(String string, PrintStream printStream) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.sliceCount; ++n) {
            if (null == this.slices[n]) continue;
            ++n2;
        }
        n = 0;
        int n3 = 0;
        for (int i = 0; i < this.sliceCount; ++i) {
            WeakReference<ByteBuffer> weakReference = this.slices2GC[i];
            if (null == weakReference) continue;
            ++n;
            if (null == weakReference.get()) continue;
            ++n3;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            l = this.fc.size();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (0 < this.refCount) {
            try {
                l2 = this.position();
                l3 = this.totalSize - l2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n4 = null != this.slices ? this.slices.length : 0;
        printStream.println(string + " refCount " + this.refCount + ", fcSize " + l + ", totalSize " + this.totalSize);
        printStream.println(string + " position " + l2 + ", remaining " + l3);
        printStream.println(string + " mmode " + this.mmode + ", cmode " + (Object)((Object)this.cmode) + ", fileResizeOp " + this.fileResizeOp);
        printStream.println(string + " slice " + this.sliceIdx + " / " + this.sliceCount + " (" + n4 + "), synchronous " + this.synchronous);
        printStream.println(string + "   mapped   " + this.slicesEntries + " / " + n2);
        printStream.println(string + "   GC-queue " + this.slices2GCEntries + " / " + n + " (alive " + n3 + ")");
        printStream.println(string + " sliceShift " + this.sliceShift + " -> " + (1L << this.sliceShift));
    }

    MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode, int n, long l, int n2) throws IOException {
        this.sliceShift = n;
        this.fc = fileChannel;
        this.mmode = mapMode;
        if (0L > l) {
            throw new IllegalArgumentException("Negative size " + l);
        }
        this.totalSize = -1L;
        this.sliceCount = 0;
        this.notifyLengthChange(l);
        this.refCount = 1;
        this.cleanerInit = false;
        this.hasCleaner = false;
        this.cmode = cacheMode;
        this.sliceIdx = n2;
        this.mark = -1L;
        this.currentSlice().position(0);
    }

    public MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode, int n) throws IOException {
        this(fileChannel, mapMode, cacheMode, n, fileChannel.size(), 0);
    }

    public MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode) throws IOException {
        this(fileChannel, mapMode, cacheMode, DEFAULT_SLICE_SHIFT);
    }

    public MappedByteBufferInputStream(FileChannel fileChannel) throws IOException {
        this(fileChannel, FileChannel.MapMode.READ_ONLY, CacheMode.FLUSH_PRE_HARD, DEFAULT_SLICE_SHIFT);
    }

    public final synchronized void setSynchronous(boolean bl) {
        this.synchronous = bl;
    }

    public final synchronized boolean getSynchronous() {
        return this.synchronous;
    }

    final synchronized void checkOpen() throws IOException {
        if (0 == this.refCount) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        if (0 < this.refCount) {
            --this.refCount;
            if (0 == this.refCount) {
                try {
                    this.cleanAllSlices(true);
                }
                finally {
                    this.flushImpl(true, false);
                    this.fc.close();
                    this.mark = -1L;
                    this.sliceIdx = -1;
                    super.close();
                }
            }
        }
    }

    final FileChannel.MapMode getMapMode() {
        return this.mmode;
    }

    public final synchronized void setFileResizeOp(FileResizeOp fileResizeOp) throws IllegalStateException {
        if (NoFileResize != this.fileResizeOp && this.fileResizeOp != fileResizeOp) {
            throw new IllegalStateException("FileResizeOp already set, this value differs");
        }
        this.fileResizeOp = null != fileResizeOp ? fileResizeOp : NoFileResize;
    }

    public final synchronized void setLength(long l) throws IOException {
        long l2 = 0L != l && this.totalSize != l ? this.position() : -1L;
        if (this.fc.size() != l) {
            if (Platform.OSType.WINDOWS == Platform.getOSType()) {
                this.cleanAllSlices(this.synchronous);
            }
            this.fileResizeOp.setLength(l);
            if (this.synchronous) {
                this.flushImpl(true, false);
            }
        }
        this.notifyLengthChangeImpl(l, l2);
    }

    public final synchronized void notifyLengthChange(long l) throws IOException {
        this.notifyLengthChangeImpl(l, -1L);
    }

    private final synchronized void notifyLengthChangeImpl(long l, long l2) throws IOException {
        if (this.totalSize == l) {
            return;
        }
        if (0L == l) {
            this.cleanAllSlices(this.synchronous);
            WeakReference[] weakReferenceArray = new WeakReference[1];
            this.slices2GC = weakReferenceArray;
            this.slices = new ByteBuffer[1];
            this.slices[0] = ByteBuffer.allocate(0);
            this.sliceCount = 0;
            this.totalSize = 0L;
            this.mark = -1L;
            this.sliceIdx = 0;
        } else {
            long l3 = 0L <= l2 ? l2 : this.position();
            long l4 = 1L << this.sliceShift;
            int n = (int)((l + (l4 - 1L)) / l4);
            WeakReference[] weakReferenceArray = new WeakReference[n];
            ByteBuffer[] byteBufferArray = new ByteBuffer[n];
            int n2 = Math.min(n, this.sliceCount - 1);
            if (0 <= n2) {
                if (0 < n2) {
                    System.arraycopy(this.slices2GC, 0, weakReferenceArray, 0, n2);
                    System.arraycopy(this.slices, 0, byteBufferArray, 0, n2);
                }
                for (int i = n2; i < this.sliceCount; ++i) {
                    this.cleanSlice(i, this.synchronous);
                }
            }
            this.slices2GC = weakReferenceArray;
            this.slices = byteBufferArray;
            this.sliceCount = n;
            this.totalSize = l;
            if (l < this.mark) {
                this.mark = -1L;
            }
            this.position2(Math.min(l3, l));
        }
    }

    public final synchronized void flush(boolean bl) throws IOException {
        this.checkOpen();
        this.flushImpl(bl, true);
    }

    private final synchronized void flushImpl(boolean bl, boolean bl2) throws IOException {
        if (FileChannel.MapMode.READ_ONLY != this.mmode) {
            if (bl2 && FileChannel.MapMode.READ_WRITE == this.mmode) {
                int n;
                for (n = 0; n < this.sliceCount; ++n) {
                    this.syncSlice(this.slices[n], true);
                }
                for (n = 0; n < this.sliceCount; ++n) {
                    WeakReference<ByteBuffer> weakReference = this.slices2GC[n];
                    if (null == weakReference) continue;
                    this.syncSlice((ByteBuffer)weakReference.get(), true);
                }
            }
            this.fc.force(bl);
        }
    }

    public final synchronized MappedByteBufferOutputStream getOutputStream(FileResizeOp fileResizeOp) throws IllegalStateException, IOException {
        this.checkOpen();
        MappedByteBufferOutputStream mappedByteBufferOutputStream = new MappedByteBufferOutputStream(this, fileResizeOp);
        ++this.refCount;
        return mappedByteBufferOutputStream;
    }

    public final synchronized ByteBuffer currentSlice() throws IOException {
        WeakReference<ByteBuffer> weakReference;
        ByteBuffer byteBuffer = this.slices[this.sliceIdx];
        if (null != byteBuffer) {
            return byteBuffer;
        }
        if (CacheMode.FLUSH_PRE_SOFT == this.cmode && null != (weakReference = this.slices2GC[this.sliceIdx])) {
            ByteBuffer byteBuffer2 = (ByteBuffer)weakReference.get();
            this.slices2GC[this.sliceIdx] = null;
            --this.slices2GCEntries;
            if (null != byteBuffer2) {
                this.slices[this.sliceIdx] = byteBuffer2;
                ++this.slicesEntries;
                return byteBuffer2;
            }
        }
        long l = (long)this.sliceIdx << this.sliceShift;
        MappedByteBuffer mappedByteBuffer = this.fc.map(this.mmode, l, Math.min(1L << this.sliceShift, this.totalSize - l));
        this.slices[this.sliceIdx] = mappedByteBuffer;
        ++this.slicesEntries;
        return mappedByteBuffer;
    }

    public final synchronized ByteBuffer nextSlice() throws IOException {
        if (this.sliceIdx < this.sliceCount - 1) {
            this.flushSlice(this.sliceIdx, this.synchronous);
            ++this.sliceIdx;
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(0);
            return byteBuffer;
        }
        return null;
    }

    synchronized void syncSlice(ByteBuffer byteBuffer) throws IOException {
        this.syncSlice(byteBuffer, this.synchronous);
    }

    synchronized void syncSlice(ByteBuffer byteBuffer, boolean bl) throws IOException {
        block3: {
            if (bl && null != byteBuffer && FileChannel.MapMode.READ_WRITE == this.mmode) {
                try {
                    ((MappedByteBuffer)byteBuffer).force();
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block3;
                    System.err.println("Caught " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
    }

    private synchronized void flushSlice(int n, boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.slices[n];
        if (null != byteBuffer) {
            if (CacheMode.FLUSH_NONE != this.cmode) {
                this.slices[n] = null;
                --this.slicesEntries;
                if (CacheMode.FLUSH_PRE_HARD == this.cmode) {
                    if (!this.cleanBuffer(byteBuffer, bl)) {
                        this.slices2GC[n] = new WeakReference<ByteBuffer>(byteBuffer);
                        ++this.slices2GCEntries;
                    }
                } else {
                    this.syncSlice(byteBuffer, bl);
                    this.slices2GC[n] = new WeakReference<ByteBuffer>(byteBuffer);
                    ++this.slices2GCEntries;
                }
            } else {
                this.syncSlice(byteBuffer, bl);
            }
        }
    }

    private synchronized void cleanAllSlices(boolean bl) throws IOException {
        if (null != this.slices) {
            for (int i = 0; i < this.sliceCount; ++i) {
                this.cleanSlice(i, bl);
            }
            if (0 != this.slicesEntries || 0 != this.slices2GCEntries) {
                String string = "mappedSliceCount " + this.slicesEntries + ", slices2GCEntries " + this.slices2GCEntries;
                this.dbgDump(string + ": ", System.err);
                throw new InternalError(string);
            }
        }
    }

    private synchronized void cleanSlice(int n, boolean bl) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = this.slices[n];
        WeakReference<ByteBuffer> weakReference = this.slices2GC[n];
        this.slices2GC[n] = null;
        if (null != weakReference) {
            --this.slices2GCEntries;
            byteBuffer = (ByteBuffer)weakReference.get();
        } else {
            byteBuffer = null;
        }
        if (null != byteBuffer2) {
            this.slices[n] = null;
            --this.slicesEntries;
            this.cleanBuffer(byteBuffer2, bl);
            if (null != byteBuffer) {
                throw new InternalError("XXX");
            }
        } else if (null != byteBuffer) {
            this.cleanBuffer(byteBuffer, bl);
        }
    }

    private synchronized boolean cleanBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
        boolean bl2;
        block6: {
            if (!this.cleanerInit) {
                this.initCleaner(byteBuffer);
            }
            this.syncSlice(byteBuffer, bl);
            if (!byteBuffer.isDirect()) {
                return false;
            }
            bl2 = false;
            if (this.hasCleaner) {
                try {
                    this.cClean.invoke(this.mbbCleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    this.hasCleaner = false;
                    if (!DEBUG) break block6;
                    System.err.println("Caught " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        if (!bl2 && CacheMode.FLUSH_PRE_HARD == this.cmode) {
            this.cmode = CacheMode.FLUSH_PRE_SOFT;
        }
        return bl2;
    }

    private synchronized void initCleaner(final ByteBuffer byteBuffer) {
        boolean bl;
        final Method[] methodArray = new Method[]{null};
        final Method[] methodArray2 = new Method[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block2: {
                    try {
                        methodArray[0] = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        methodArray[0].setAccessible(true);
                        methodArray2[0] = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                        methodArray2[0].setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block2;
                        System.err.println("Caught " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
                return null;
            }
        });
        this.mbbCleaner = methodArray[0];
        this.cClean = methodArray2[0];
        boolean bl2 = bl = null != this.mbbCleaner && null != this.cClean;
        if (DEBUG) {
            System.err.println("initCleaner: Has cleaner: " + bl + ", mbbCleaner " + this.mbbCleaner + ", cClean " + this.cClean);
        }
        this.hasCleaner = bl;
        this.cleanerInit = true;
    }

    public final synchronized CacheMode getCacheMode() {
        return this.cmode;
    }

    public final synchronized long length() {
        return this.totalSize;
    }

    public final synchronized long remaining() throws IOException {
        return 0 < this.refCount ? this.totalSize - this.position() : 0L;
    }

    @Override
    public final synchronized int available() throws IOException {
        long l = this.remaining();
        return l <= Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
    }

    public final synchronized long position() throws IOException {
        if (0 < this.refCount) {
            return ((long)this.sliceIdx << this.sliceShift) + (long)this.currentSlice().position();
        }
        return 0L;
    }

    public final synchronized MappedByteBufferInputStream position(long l) throws IOException {
        this.checkOpen();
        if (this.totalSize < l || 0L > l) {
            throw new IllegalArgumentException("new position " + l + " not within [0.." + this.totalSize + "]");
        }
        int n = this.sliceIdx;
        if (this.totalSize == l) {
            this.sliceIdx = Math.max(0, this.sliceCount - 1);
            if (n != this.sliceIdx) {
                this.flushSlice(n, this.synchronous);
            }
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(byteBuffer.capacity());
        } else {
            this.sliceIdx = (int)(l >>> this.sliceShift);
            if (n != this.sliceIdx) {
                this.flushSlice(n, this.synchronous);
            }
            this.currentSlice().position((int)(l - ((long)this.sliceIdx << this.sliceShift)));
        }
        return this;
    }

    private final synchronized void position2(long l) throws IOException {
        if (this.totalSize == l) {
            this.sliceIdx = Math.max(0, this.sliceCount - 1);
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(byteBuffer.capacity());
        } else {
            this.sliceIdx = (int)(l >>> this.sliceShift);
            this.currentSlice().position((int)(l - ((long)this.sliceIdx << this.sliceShift)));
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized void mark(int n) {
        if (0 < this.refCount) {
            try {
                this.mark = this.position();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.checkOpen();
        if (this.mark == -1L) {
            throw new IOException("mark not set");
        }
        this.position(this.mark);
    }

    @Override
    public final synchronized long skip(long l) throws IOException {
        this.checkOpen();
        if (0L > l) {
            return 0L;
        }
        long l2 = this.position();
        long l3 = this.totalSize - l2;
        long l4 = Math.min(l3, l);
        this.position(l2 + l4);
        return l4;
    }

    @Override
    public final synchronized int read() throws IOException {
        this.checkOpen();
        ByteBuffer byteBuffer = this.currentSlice();
        if (!byteBuffer.hasRemaining() && null == (byteBuffer = this.nextSlice())) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.checkOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("offset " + n + ", length " + n2 + ", b.length " + byArray.length);
        }
        if (0 == n2) {
            return 0;
        }
        long l = this.remaining();
        if (0L == l) {
            return -1;
        }
        int n4 = (int)Math.min(l, (long)n2);
        for (int i = 0; i < n4; i += n3) {
            ByteBuffer byteBuffer = this.currentSlice();
            int n5 = byteBuffer.remaining();
            if (0 == n5) {
                byteBuffer = this.nextSlice();
                if (null == byteBuffer) {
                    throw new InternalError("Unexpected EOT");
                }
                n5 = byteBuffer.remaining();
            }
            n3 = Math.min(n4 - i, n5);
            byteBuffer.get(byArray, n + i, n3);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int read(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        this.checkOpen();
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n + ", b " + byteBuffer);
        }
        if (0 == n) {
            return 0;
        }
        long l = this.remaining();
        if (0L == l) {
            return -1;
        }
        int n3 = (int)Math.min(l, (long)n);
        for (int i = 0; i < n3; i += n2) {
            ByteBuffer byteBuffer2 = this.currentSlice();
            int n4 = byteBuffer2.remaining();
            if (0 == n4) {
                byteBuffer2 = this.nextSlice();
                if (null == byteBuffer2) {
                    throw new InternalError("Unexpected EOT");
                }
                n4 = byteBuffer2.remaining();
            }
            n2 = Math.min(n3 - i, n4);
            if (byteBuffer2.hasArray() && byteBuffer.hasArray()) {
                System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2);
                byteBuffer2.position(byteBuffer2.position() + n2);
                byteBuffer.position(byteBuffer.position() + n2);
                continue;
            }
            if (n2 == n4) {
                byteBuffer.put(byteBuffer2);
                continue;
            }
            int n5 = byteBuffer2.limit();
            byteBuffer2.limit(n2);
            try {
                byteBuffer.put(byteBuffer2);
                continue;
            }
            finally {
                byteBuffer2.limit(n5);
            }
        }
        return n3;
    }

    static {
        Platform.initSingleton();
        DEFAULT_SLICE_SHIFT = Platform.is32Bit() ? 29 : 30;
        DEBUG = Debug.debug("ByteBufferInputStream");
    }

    public static interface FileResizeOp {
        public void setLength(long var1) throws IOException;
    }

    public static enum CacheMode {
        FLUSH_NONE,
        FLUSH_PRE_SOFT,
        FLUSH_PRE_HARD;

    }
}

