/*
 * Decompiled with CFR 0.152.
 */
abstract class Sample {
    Sample() {
    }

    public abstract Sample buildFromBytes(byte[] var1);

    public abstract Sample buildFromDouble(double var1);

    public abstract byte[] convertToBytes();

    public abstract double convertToDouble();

    public static Sample[][] buildManyFromDoubles(SamplingInfo samplingInfo, double[][] input) {
        int numberOfChannels = input.length;
        Sample[][] returnSamples = new Sample[numberOfChannels][];
        int samplesPerChannel = input[0].length;
        int c = 0;
        while (c < numberOfChannels) {
            returnSamples[c] = new Sample[samplesPerChannel];
            ++c;
        }
        Sample samplePrototype = samplingInfo.samplePrototype();
        int s = 0;
        while (s < samplesPerChannel) {
            int c2 = 0;
            while (c2 < numberOfChannels) {
                returnSamples[c2][s] = samplePrototype.buildFromDouble(input[c2][s]);
                ++c2;
            }
            ++s;
        }
        return returnSamples;
    }

    public static Sample[][] buildManyFromBytes(SamplingInfo samplingInfo, byte[] bytesToConvert) {
        int numberOfBytes = bytesToConvert.length;
        int numberOfChannels = samplingInfo.numberOfChannels;
        Sample[][] returnSamples = new Sample[numberOfChannels][];
        int bytesPerSample = samplingInfo.bitsPerSample / 8;
        int samplesPerChannel = numberOfBytes / bytesPerSample / numberOfChannels;
        int c = 0;
        while (c < numberOfChannels) {
            returnSamples[c] = new Sample[samplesPerChannel];
            ++c;
        }
        int b = 0;
        Math.pow(2.0, 8 * bytesPerSample - 1);
        Sample samplePrototype = samplingInfo.samplePrototype();
        byte[] sampleValueAsBytes = new byte[bytesPerSample];
        int s = 0;
        while (s < samplesPerChannel) {
            int c2 = 0;
            while (c2 < numberOfChannels) {
                int i = 0;
                while (i < bytesPerSample) {
                    sampleValueAsBytes[i] = bytesToConvert[b];
                    ++b;
                    ++i;
                }
                returnSamples[c2][s] = samplePrototype.buildFromBytes(sampleValueAsBytes);
                ++c2;
            }
            ++s;
        }
        return returnSamples;
    }

    public static Sample[] concatenateSets(Sample[][] setsToConcatenate) {
        int numberOfSamplesSoFar = 0;
        int i = 0;
        while (i < setsToConcatenate.length) {
            Sample[] setToConcatenate = setsToConcatenate[i];
            numberOfSamplesSoFar += setToConcatenate.length;
            ++i;
        }
        Sample[] returnValues = new Sample[numberOfSamplesSoFar];
        int s = 0;
        int i2 = 0;
        while (i2 < setsToConcatenate.length) {
            Sample[] setToConcatenate = setsToConcatenate[i2];
            int j = 0;
            while (j < setToConcatenate.length) {
                returnValues[s] = setToConcatenate[j];
                ++s;
                ++j;
            }
            ++i2;
        }
        return returnValues;
    }

    public static byte[] convertManyToBytes(Sample[][] samplesToConvert, SamplingInfo samplingInfo) {
        byte[] returnBytes = null;
        int numberOfChannels = samplingInfo.numberOfChannels;
        int samplesPerChannel = samplesToConvert[0].length;
        short bitsPerSample = samplingInfo.bitsPerSample;
        int bytesPerSample = bitsPerSample / 8;
        int numberOfBytes = numberOfChannels * samplesPerChannel * bytesPerSample;
        returnBytes = new byte[numberOfBytes];
        Math.pow(2.0, 8 * bytesPerSample - 1);
        int b = 0;
        int s = 0;
        while (s < samplesPerChannel) {
            int c = 0;
            while (c < numberOfChannels) {
                Sample sample = samplesToConvert[c][s];
                byte[] sampleAsBytes = sample.convertToBytes();
                int i = 0;
                while (i < bytesPerSample) {
                    returnBytes[b] = sampleAsBytes[i];
                    ++b;
                    ++i;
                }
                ++c;
            }
            ++s;
        }
        return returnBytes;
    }

    public static Sample[] superimposeSets(Sample[][] setsToSuperimpose) {
        int maxSamplesSoFar = 0;
        int i = 0;
        while (i < setsToSuperimpose.length) {
            Sample[] setToSuperimpose = setsToSuperimpose[i];
            if (setToSuperimpose.length > maxSamplesSoFar) {
                maxSamplesSoFar = setToSuperimpose.length;
            }
            ++i;
        }
        Sample[] returnValues = new Sample[maxSamplesSoFar];
        int i2 = 0;
        while (i2 < setsToSuperimpose.length) {
            Sample[] setToSuperimpose = setsToSuperimpose[i2];
            int j = 0;
            while (j < setToSuperimpose.length) {
                Sample sampleToSuperimpose = setToSuperimpose[j];
                double sampleValueAsDouble = sampleToSuperimpose.convertToDouble();
                if (i2 > 0) {
                    sampleValueAsDouble += returnValues[i2].convertToDouble();
                }
                returnValues[i2] = sampleToSuperimpose.buildFromDouble(sampleValueAsDouble);
                ++j;
            }
            ++i2;
        }
        return returnValues;
    }
}

