/*
 * Decompiled with CFR 0.152.
 */
class SamplingInfo {
    public String name;
    public int chunkSize;
    public short formatCode;
    public short numberOfChannels;
    public int samplesPerSecond;
    public short bitsPerSample;

    public SamplingInfo(String name, int chunkSize, short formatCode, short numberOfChannels, int samplesPerSecond, short bitsPerSample) {
        this.name = name;
        this.chunkSize = chunkSize;
        this.formatCode = formatCode;
        this.numberOfChannels = numberOfChannels;
        this.samplesPerSecond = samplesPerSecond;
        this.bitsPerSample = bitsPerSample;
    }

    public int bytesPerSecond() {
        return this.samplesPerSecond * this.numberOfChannels * this.bitsPerSample / 8;
    }

    public Sample samplePrototype() {
        Sample returnValue = null;
        if (this.bitsPerSample == 16) {
            returnValue = new Sample16(0);
        } else if (this.bitsPerSample == 24) {
            returnValue = new Sample24(0);
        } else if (this.bitsPerSample == 32) {
            returnValue = new Sample32(0);
        }
        return returnValue;
    }

    public String toString() {
        String returnValue = "<SamplingInfo chunkSize='" + this.chunkSize + "' " + "formatCode='" + this.formatCode + "' " + "numberOfChannels='" + this.numberOfChannels + "' " + "samplesPerSecond='" + this.samplesPerSecond + "' " + "bitsPerSample='" + this.bitsPerSample + "' " + "/>";
        return returnValue;
    }

    public static class Instances {
        public static SamplingInfo Default = new SamplingInfo("Default", 16, 1, 1, 44100, 16);
    }
}

