/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class WavFile {
    public String filePath;
    public SamplingInfo samplingInfo;
    public Sample[][] samplesForChannels;

    public WavFile(String filePath, double[][] samplesForChannels) {
        this.samplingInfo = new SamplingInfo("wave", 16, 1, 2, 44100, 16);
        this.setSamplesFromDouble(samplesForChannels);
        this.writeToFilePath(filePath);
    }

    public WavFile(String filePath, SamplingInfo samplingInfo, Sample[][] samplesForChannels) {
        this.filePath = filePath;
        this.samplingInfo = samplingInfo;
        this.samplesForChannels = samplesForChannels;
    }

    public double[][] samplesAsDouble() {
        double[][] result = new double[this.samplesForChannels.length][];
        int i = 0;
        while (i < this.samplesForChannels.length) {
            result[i] = new double[this.samplesForChannels[i].length];
            int j = 0;
            while (j < this.samplesForChannels[i].length) {
                result[i][j] = this.samplesForChannels[i][j].convertToDouble();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void setSamplesFromDouble(double[][] input) {
        this.samplingInfo.numberOfChannels = (short)input.length;
        this.samplesForChannels = Sample.buildManyFromDoubles(this.samplingInfo, input);
    }

    public static WavFile readFromFilePath(String filePathToReadFrom) {
        WavFile returnValue = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(filePathToReadFrom)));
            DataInputStreamLittleEndian reader = new DataInputStreamLittleEndian(dataInputStream);
            byte[] riff = new byte[4];
            reader.read(riff);
            reader.readInt();
            byte[] wave = new byte[4];
            reader.read(wave);
            byte[] fmt = new byte[4];
            reader.read(fmt);
            int chunkSize = reader.readInt();
            Short formatCode = reader.readShort();
            Short numberOfChannels = reader.readShort();
            int samplesPerSecond = reader.readInt();
            reader.readInt();
            reader.readShort();
            Short bitsPerSample = reader.readShort();
            byte[] data = new byte[4];
            reader.read(data);
            int subchunk2Size = reader.readInt();
            byte[] samplesForChannelsMixedAsBytes = new byte[subchunk2Size];
            reader.read(samplesForChannelsMixedAsBytes);
            reader.close();
            SamplingInfo samplingInfo = new SamplingInfo("[from file]", chunkSize, formatCode, numberOfChannels, samplesPerSecond, bitsPerSample);
            Sample[][] samplesForChannels = Sample.buildManyFromBytes(samplingInfo, samplesForChannelsMixedAsBytes);
            returnValue = new WavFile(filePathToReadFrom, samplingInfo, samplesForChannels);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    public void writeToFilePath(String url) {
        this.filePath = url;
        this.writeToFilePath();
    }

    public void writeToFilePath() {
        try {
            int subchunk2Size = this.samplesForChannels[0].length * this.samplingInfo.numberOfChannels * this.samplingInfo.bitsPerSample / 8;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.filePath)));
            DataOutputStreamLittleEndian writer = new DataOutputStreamLittleEndian(dataOutputStream);
            writer.writeString("RIFF");
            writer.writeInt(subchunk2Size + 36);
            writer.writeString("WAVE");
            writer.writeString("fmt ");
            writer.writeInt(this.samplingInfo.chunkSize);
            writer.writeShort(this.samplingInfo.formatCode);
            writer.writeShort(this.samplingInfo.numberOfChannels);
            writer.writeInt(this.samplingInfo.samplesPerSecond);
            writer.writeInt(this.samplingInfo.bytesPerSecond());
            writer.writeShort((short)(this.samplingInfo.numberOfChannels * this.samplingInfo.bitsPerSample / 8));
            writer.writeShort(this.samplingInfo.bitsPerSample);
            writer.writeString("data");
            writer.writeInt(subchunk2Size);
            byte[] samplesAsBytes = Sample.convertManyToBytes(this.samplesForChannels, this.samplingInfo);
            writer.writeBytes(samplesAsBytes);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

