/*
 * Decompiled with CFR 0.152.
 */
import drop.DropEvent;
import drop.SDrop;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class waveformReader
extends PApplet {
    SDrop drop;
    PImage im;
    float threshold = 128.0f;
    int sLength = 100000;
    float oscillation = 200.0f;
    float filter = 95.0f;
    float[] mins;
    float[] maxs;
    ArrayList<Slider> sliders = new ArrayList();
    boolean allowProcess = false;
    boolean detectionInverted = false;

    public void setup() {
        this.drop = new SDrop((PApplet)this);
        Slider thS = new Slider();
        thS.label = "threshold";
        thS.min = 0.0f;
        thS.max = 255.0f;
        thS.value = this.threshold;
        thS.pos = new PVector(20.0f, 20.0f);
        this.sliders.add(thS);
        Slider slS = new Slider();
        slS.label = "sample length";
        slS.min = 10.0f;
        slS.max = 1000000.0f;
        slS.value = this.sLength;
        slS.pos = new PVector(20.0f, 50.0f);
        this.sliders.add(slS);
        Slider osS = new Slider();
        osS.label = "oscillation";
        osS.min = 1.0f;
        osS.max = 1000.0f;
        osS.value = this.oscillation;
        osS.pos = new PVector(20.0f, 80.0f);
        this.sliders.add(osS);
        Slider fiS = new Slider();
        fiS.label = "filter";
        fiS.min = 0.0f;
        fiS.max = 100.0f;
        fiS.value = this.filter;
        fiS.pos = new PVector(20.0f, 110.0f);
        this.sliders.add(fiS);
    }

    public void draw() {
        this.background(255);
        if (this.allowProcess) {
            for (Slider s : this.sliders) {
                s.update();
            }
            this.threshold = this.sliders.get((int)0).value;
            this.sLength = waveformReader.ceil((float)this.sliders.get((int)1).value);
            this.oscillation = this.sliders.get((int)2).value;
            this.filter = this.sliders.get((int)3).value;
            this.process();
            this.image(this.im, 0.0f, 0.0f, this.width, this.height);
            this.stroke(0.0f, 128.0f, 0.0f, 128.0f);
            this.noFill();
            int x = 0;
            while (x < this.mins.length) {
                this.line((float)x * (float)this.width / (float)this.mins.length, waveformReader.map((float)this.mins[x], (float)-1.0f, (float)1.0f, (float)this.height, (float)0.0f), (float)x * (float)this.width / (float)this.mins.length, waveformReader.map((float)this.maxs[x], (float)-1.0f, (float)1.0f, (float)this.height, (float)0.0f));
                ++x;
            }
            for (Slider s : this.sliders) {
                s.draw();
            }
            this.text("CTRL : invert detection", 20.0f, 140.0f);
            this.text("TAB : export", 20.0f, 170.0f);
        } else {
            this.fill(0);
            this.textAlign(3, 3);
            this.text("drag and drop a picture", this.width / 2, this.height / 2);
        }
    }

    public void dropEvent(DropEvent theDropEvent) {
        this.allowProcess = false;
        this.im = this.loadImage(theDropEvent.file().toString());
        this.allowProcess = true;
    }

    public void process() {
        this.mins = new float[this.im.width];
        this.maxs = new float[this.im.width];
        int x = 0;
        while (x < this.im.width) {
            this.mins[x] = 1.0f;
            this.maxs[x] = -1.0f;
            boolean valueFound = false;
            int y = 0;
            while (y < this.im.height) {
                float thisValue = waveformReader.map((float)y, (float)0.0f, (float)(this.im.height - 1), (float)1.0f, (float)-1.0f);
                float thisBrightness = this.brightness(this.im.get(x, y));
                if (thisBrightness < this.threshold ^ this.detectionInverted) {
                    this.mins[x] = waveformReader.min((float)this.mins[x], (float)thisValue);
                    this.maxs[x] = waveformReader.max((float)this.maxs[x], (float)thisValue);
                    valueFound = true;
                }
                ++y;
            }
            if (!valueFound) {
                this.maxs[x] = 0.0f;
                this.mins[x] = 0.0f;
            }
            ++x;
        }
    }

    public void keyPressed() {
        if (this.keyCode == 9) {
            this.export();
        }
        if (this.keyCode == 17) {
            this.detectionInverted ^= true;
        }
    }

    public void export() {
        double[] resultWaveform = new double[this.sLength];
        double currentValue = 0.0;
        boolean direction = false;
        float switchDirectionEvery = this.oscillation;
        float switchDirectionCounter = 0.0f;
        double prevValue = 0.0;
        int i = 0;
        while (i < resultWaveform.length) {
            int pixelX = waveformReader.floor((float)((float)i * (float)this.im.width / (float)resultWaveform.length));
            currentValue = direction ? (double)this.maxs[pixelX] : (double)this.mins[pixelX];
            prevValue = currentValue = currentValue * (1.0 - (double)(this.filter / 100.0f)) + prevValue * (double)this.filter / 100.0;
            resultWaveform[i] = currentValue;
            if ((switchDirectionCounter += 1.0f) >= switchDirectionEvery) {
                switchDirectionCounter -= switchDirectionEvery;
                direction ^= true;
            }
            ++i;
        }
        double[][] resultWaveformStereo = new double[2][resultWaveform.length];
        int i2 = 0;
        while (i2 < resultWaveform.length) {
            double d = resultWaveform[i2];
            resultWaveformStereo[1][i2] = d;
            resultWaveformStereo[0][i2] = d;
            ++i2;
        }
        new WavFile(this.sketchPath("result.wav"), resultWaveformStereo);
    }

    public void settings() {
        this.size(800, 600);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"waveformReader"};
        if (passedArgs != null) {
            PApplet.main((String[])waveformReader.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Slider {
        String label;
        PVector pos;
        PVector size = new PVector(200.0f, 20.0f);
        float min;
        float max;
        float value;

        Slider() {
        }

        public void update() {
            if (waveformReader.this.mousePressed && (float)waveformReader.this.mouseX >= this.pos.x && (float)waveformReader.this.mouseY >= this.pos.y && (float)waveformReader.this.mouseX <= this.pos.x + this.size.x && (float)waveformReader.this.mouseY <= this.pos.y + this.size.y) {
                this.value = ((float)waveformReader.this.mouseX - this.pos.x) * (this.max - this.min) / this.size.x + this.min;
            }
        }

        public void draw() {
            waveformReader.this.stroke(80.0f, 0.0f, 144.0f);
            waveformReader.this.line(this.pos.x + (this.value - this.min) * this.size.x / (this.max - this.min), this.pos.y, this.pos.x + (this.value - this.min) * this.size.x / (this.max - this.min), this.pos.y + this.size.y);
            waveformReader.this.stroke(192.0f, 0.0f, 192.0f);
            waveformReader.this.noFill();
            waveformReader.this.rect(this.pos.x, this.pos.y, this.size.x, this.size.y);
            waveformReader.this.fill(192.0f, 0.0f, 192.0f);
            waveformReader.this.textAlign(37, 101);
            waveformReader.this.text(String.valueOf(this.label) + " : " + waveformReader.floor((float)this.value), this.pos.x + this.size.x + 10.0f, this.pos.y);
        }
    }
}

