﻿<html>
<head>
	<meta property="og:title" content="A lot of files" ></meta>
	<meta name="description" content="Some website with many files" />
	<meta property="og:description" content="Some website with many files" />
	<meta name="keywords" content="files" />
	<meta property="og:image" content="./file01.png" />
	<meta property="og:url" content="" />
	<meta property="og:type" content="website" />
	<meta name="author" content="" />
	<meta charset="UTF-8" />
	<meta http-equiv="content-type" content="content=text/html; charset=UTF-8" />
	<title>A lot of files</title>
	<link rel="icon"  type="image/x-icon" href="./file01.png" />

	<meta charset="utf-8" />
	<style>
		#directory {
			margin : 10px;
			width : 350px;
			float : left;
			border : solid;
			border-width : 1px;
		}
		#folderContent {
			margin : 10px;
			width : 350px;
			min-height : 700px;
			float : left;
			top : 0px;
			left : 300px;
			border : solid;
			border-width : 1px;
		}
		#fileContent {
			margin : 10px;
			border : solid;
			border-width : 1px;
			width : 350px;
			min-height : 700px;
			float : left;
		}
		.dirFolder {
			margin-top : 0px;
			margin-right : 0px;
			margin-bottom : 0px;
			margin-left : 20px;
			line-height: 20px;
			display : none;
		}
		.deployButton {
			display : inline-block; 
			margin : 5px;
			margin-top : 6px;
			cursor : pointer;
			width : 10px;
			line-height: 0px;
		}
		.folderName {
			cursor : pointer;
			vertical-align: top;
			display : inline;
			font-size : 13px;
		}
		.filFolder {
			cursor : pointer;
		}
		.dirElement {
			height : 16px;
			display : inline-block;
			margin : 5px;
			vertical-align : top;
			cursor : pointer;
		}
		.dirName {
			margin-left : 5px;
			vertical-align : top;
			font-size : 13px;
			word-wrap: break-word;
		}
		.dirName a {
			text-decoration : none;
			color : #000;
		}
		.infolink {
			font-size : 13px;
			font-style: italic;
			vertical-align : top;
			color : #888;
		}
		.folderLink {
			text-decoration : none;
			color : #000;
		}
		.imgPreview {
			padding : 10px;
			width : 300px;
		}
		.fileImg {
			margin-top : 5px;
			margin-left : 5px;
		}
	</style>
	<?php 
		$dir = "."; 
		if (isset($_GET['dir'])) $dir = ($_GET['dir']);
		$dirs = explode('/',$dir);
		foreach($dirs as $thisDir) if ($thisDir=="..") $dir=".";
	?>
	<script src="Yann%20van%20der%20Cruyssen%27s%20website_fichiers/ga.js" async="" type="text/javascript"></script><script type="text/javascript">// google analytics
			var _gaq = _gaq || [];
			_gaq.push(['_setAccount', 'UA-20833102-1']);
			_gaq.push(['_trackPageview']);
		(function() {
			var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
			ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
			var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
		})();
	</script>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
	<script type="text/javascript">
	
		$(document).on("click", ".deployButton", function() {
			var someDiv = $(this).parent();
			deploy(someDiv);
		});
		
		$(document).on("click", ".infolink", function() {
			var link = $(this).attr("link");
			var mtime = $(this).attr("mtime");
			var mdate = new Date(mtime*1000);
			var extension = link.split('.').pop().toLowerCase();
			$("#fileInfos").html('<a href="' + link + '" target="_blank">' + link + '</a><br/>modified on : ' + mdate.getFullYear() + '/' + mdate.getMonth() + '/' + mdate.getDate());
			var picExts = new Array("png","jpg","bmp","gif","jpeg");
			var txtExts = new Array("php","htm","html","txt");
			$("#filePreview").empty();
			if (searchStringInArray(extension,picExts)!=-1) $("#filePreview").html('<img class="imgPreview" src="' + link + '"></img>');
			if (searchStringInArray(extension,txtExts)!=-1) $("#filePreview").html('<object style="height:650px;width:350px;" type="text/html" data="' + link + '"></object>');
			
		});
		
		function searchStringInArray (str, strArray) {
			for (var j=0; j<strArray.length; j++) {
				if (strArray[j].match(str)) return j;
			}
			return -1;
		}
		
		$(document).ready(function() {
			var dir = "<?php Print($dir); ?>";
			if (dir=="" || dir==".") dir="./";
			var dirs = dir.split("/");
			$("#fileInfos").html("current directory : <a href=\"" + dir + "\">" + dir + "</a><br/>");
			var currentDir = $("#directory");
			currentDir.children(".dirFolder").show();
			for (var i=0; i<dirs.length ;i++) {
				if (dirs[i]!=".") {
					var nextElement;
					for (var j=0;j<$(currentDir).children(".dirFolder").length;j++) {
						var thisChild = currentDir.children(".dirFolder")[j];
						if ($(currentDir.children(".dirFolder")[j]).attr("name")==dirs[i]) nextElement = $(currentDir.children(".dirFolder")[j]);
					}
					if (nextElement) currentDir = nextElement;
					else break;
					deploy($(currentDir));
				}
			}
		});
		
		function deploy(someDiv) {
			if (someDiv.children(".deployButton").attr('deployed')=='false') {
				someDiv.children('.dirFolder').show();
				someDiv.children(".deployButton").html('<img src="reduce01.png" />');
				someDiv.children(".deployButton").attr('deployed','true');
			} else if (someDiv.children(".deployButton").attr('deployed')=='true') {
				someDiv.children('.dirFolder').hide();
				someDiv.children(".deployButton").html('<img src="deploy01.png" />');
				someDiv.children(".deployButton").attr('deployed','false');
			}			
		}

	</script>
	<?php

		function getDirectoryList($directory) {
			$results = array();
			$handler = opendir($directory);
			while ($file = readdir($handler)) {
				if ($file != "." && $file != "..") {
					$results[] = $file;
				}
			}
			closedir($handler);
			sort($results);
			return $results;
		}
		
		function getOnlyDirs($directory) {
			$results = array();
			$handler = opendir($directory);
			while ($file = readdir($handler)) {
				if ($file != "." && $file != ".." && is_dir($directory."/".$file)) {
					$results[] = $file;
				}
			}
			closedir($handler);
			sort($results);
			return $results;
		}
		
		function displayFolder($folder) {
			$elements = getDirectoryList($folder);
			foreach ($elements AS $element) {
				if (is_dir($folder."/".$element)) {
					echo '<div class="dirFolder" targetUrl="' . $folder."/".$element . '" name="' . $element . '">';
					echo '<div class="deployButton" ';
					if (count(getOnlyDirs($folder."/".$element))>0) echo 'deployed="false"';
					else echo 'deployed="none"';
					echo '>';
					if (count(getOnlyDirs($folder."/".$element))>0) echo '<img src="deploy01.png" />';
					echo '</div>';
					echo '<div class="folderName"><a class="folderLink" href="?dir=' . urlencode($folder . "/" . $element) . '">' . $element . '</a></div>';
					displayFolder($folder."/".$element);
					echo '</div>';
				}
			}
		}

		function displayFiles($folder) {
			$elements = getDirectoryList($folder);
			foreach ($elements AS $element) {
				if (is_dir($folder."/".$element)) {
					echo '<img class="fileImg" src="fileFolder01.png" /><div class="dirElement" ><span class="dirName"><a href="?dir=' . urlencode($folder . "/" . $element) . '">' . $element . '</a></span>';
					echo '</div><br/>';
				}
			}
			foreach ($elements AS $element) {
				$filePicUrl="file01.png";
				$ext = strtolower(substr($element, strrpos($element, '.')+1));
				if ($ext=="wav"||$ext=="mp3"||$ext=="ogg"||$ext=="flac") $filePicUrl="fileAudio01.png";
				if ($ext=="txt"||$ext=="htm"||$ext=="html"||$ext=="php") $filePicUrl="fileText01.png";
				if ($ext=="jpg"||$ext=="jpeg"||$ext=="png"||$ext=="bmp"||$ext=="gif") $filePicUrl="filePic01.png";
				if ($ext=="zip"||$ext=="7z"||$ext=="rar") $filePicUrl="fileZip01.png";
				if (!is_dir($folder."/".$element)) {
					echo '<img class="fileImg" src="' . $filePicUrl . '" /><div class="dirElement" ><span class="dirName"><a href="'.$folder."/".$element.'" target="_blank">' . $element . "</a></span>";
					echo ' <span class="infolink" link="' . $folder . '/' . $element . '" mtime="' . filemtime($folder . "/" . $element) . '">preview</span>';
					echo '</div><br/>';
				}
			}			
		}

	?>
</head>
<body>
	<div id="directory" name=".">
		<?php displayFolder(".");?>
	</div>
	<div id="folderContent">
		<?php displayFiles($dir); ?>
	</div>
	<div id="fileContent">
		<div id="fileInfos"></div>
		<div id="filePreview"></div>
	</div>
</body>
</html>
