
import processing.serial.*;
Serial myPort;  

void setup() {
  println(Serial.list());
  myPort = new Serial(this, Serial.list()[0], 9600);
  PImage input = loadImage("input.png");
  float[][] briV = new float[40*2][25*3];
  for (int x=0; x<40*2; x++) {
    for (int y=0; y<24*3; y++) {
      briV[x][y] = getBrightnessOf(input, x*input.width/(40*2), y*input.height/(25*3), input.width/(40*2), input.height/(25*3));
    }
  }

  // size(40*2, 24*3);
  size(80, 72);
  float[][] bck = new float[40][25];
  float[][] txt = new float[40][25];  
  float[][] chr = new float[40][25];
  for (int y=0; y<24; y++) {  
    for (int x=0; x<40; x++) {
      float[][] thisBriV = new float[2][3];
      for (int x2=0; x2<2; x2++) {
        for (int y2=0; y2<3; y2++) {
          thisBriV[x2][y2] = briV[x*2+x2][y*3+y2];
        }
      }
      int[] thisV = getCharValuesFor(thisBriV);
      bck[x][y] = thisV[0];
      txt[x][y] = thisV[1];
      chr[x][y] = thisV[2];
    }
  }

  clearScreen();
  delay(100);
  setMode(0);

  for (int y=0; y<24; y++) {  
    for (int x=0; x<40; x++) {
      delay(100);
      setBackgroundColor(floor(bck[x][y]));
      delay(100);
      setTextColor(floor(txt[x][y]));      
      delay(100);
      myPort.write(floor(chr[x][y]));
      delay(100);
    }
  }
}

void draw() {
}

float getBrightnessOf(PImage in, int x, int y, int w, int h) {
  float bri=0;
  int divi=0;
  for (int pX=x; pX<min(x+w, in.width); pX++) {
    for (int pY=y; pY<min(y+h, in.height); pY++) {
      bri += brightness(in.get(pX, pY));
      divi++;
    }
  }
  bri /= divi;
  bri /= 0xFF;
  return bri;
}

int[] getCharValuesFor(float[][] briV) {
  float minV = 1;
  float maxV = 0;
  for (int x=0; x<2; x++) {
    for (int y=0; y<3; y++) {
      if (briV[x][y]<minV) minV = briV[x][y];
      if (briV[x][y]>maxV) maxV = briV[x][y];
    }
  }
  int[] result = new int[3];
  result[0] = floor(minV*8);
  result[1] = floor(maxV*8);
  boolean[][] on = new boolean[2][3];
  for (int x=0; x<2; x++) {
    for (int y=0; y<3; y++) {
      if (abs(briV[x][y]-minV)>abs(briV[x][y]-maxV)) on[x][y] = false;
      else on[x][y] = true;
    }
  }
  result[2] = shapeValue(on);
  return result;
}

int shapeValue(boolean[][] p) {
  int value=32;
  if (p[0][0]) value+=32;
  if (p[1][0]) value+=16;
  if (p[0][1]) value+=8;
  if (p[1][1]) value+=4;
  if (p[0][2]) value+=2;
  if (p[1][2]) value+=1;
  return value;
}

void moveCursor(int x, int y) {
  x = constrain(x, -1, 1);
  y = constrain(y, -1, 1);
  if (x ==  1) myPort.write((byte)9);
  if (x == -1) myPort.write((byte)8);
  if (y ==  1) myPort.write((byte)10);
  if (y == -1) myPort.write((byte)11);
}

void fontMagnify(boolean x, boolean y) {
  myPort.write((byte)27);
  if (x) {
    if (y) myPort.write((byte)79);
    else myPort.write((byte)78);
  } else {
    if (y) myPort.write((byte)77);
    else myPort.write((byte)76);
  }
}

void clearScreen() {
  myPort.write((byte)12);
}
void setMode(int m) {
  if (m==0) myPort.write((byte)14);// 0 for graphical mode
  if (m==1) myPort.write((byte)15);// 1 for text mode
}
void setBackgroundColor(int c) {
  myPort.write((byte)27);
  myPort.write((byte)80 + floor((float)c/2)+(c%2)*4);
}
void setTextColor(int c) {
  myPort.write((byte)27);
  myPort.write((byte)64 + floor((float)c/2)+(c%2)*4);
}
