

void setup() {
  PImage input = loadImage("input.png");
  float[][] briV = new float[40*2][25*3];
  for (int x=0;x<40*2;x++) {
    for (int y=0;y<24*3;y++) {
      briV[x][y] = getBrightnessOf(input, x*input.width/(40*2), y*input.height/(25*3), input.width/(40*2), input.height/(25*3));
    }
  }

  size(40*2, 24*3);
  ArrayList minitelLine = new ArrayList();
  float[][] bck = new float[40][25];
  float[][] txt = new float[40][25];  
  float[][] chr = new float[40][25];
  for (int y=0;y<24;y++) {  
    for (int x=0;x<40;x++) {
      float[][] thisBriV = new float[2][3];
      for (int x2=0;x2<2;x2++) {
        for (int y2=0;y2<3;y2++) {
          thisBriV[x2][y2] = briV[x*2+x2][y*3+y2];
        }
      }
      int[] thisV = getCharValuesFor(thisBriV);
      bck[x][y] = thisV[0];
      txt[x][y] = thisV[1];
      chr[x][y] = thisV[2];
    }
  }
  minitelLine.add("void setup() {");
  minitelLine.add("UCSR0C = B00100100;");
  minitelLine.add("Serial.begin(1200);");
  minitelLine.add("Serial.write((byte)12);");
  minitelLine.add("clearScreen();");
  minitelLine.add("setMode(0);");
  minitelLine.add("}");
  minitelLine.add("void loop() {");  
  minitelLine.add("graph();");
  minitelLine.add("}");
  minitelLine.add("void graph() {");
  for (int y=0;y<24;y++) {  
    for (int x=0;x<40;x++) {
      minitelLine.add("setBackgroundColor(" + bck[x][y] + ");");
      minitelLine.add("setTextColor(" + txt[x][y] + ");");      
      minitelLine.add("Serial.write(" + chr[x][y] + ");");
    }
  }
  minitelLine.add("}");  
  minitelLine.add("void clearScreen() {");
  minitelLine.add("Serial.write((byte)12);");
  minitelLine.add("}");
  minitelLine.add("void setMode(int m) {");
  minitelLine.add("if (m==0) Serial.write((byte)14);// 0 for graphical mode");
  minitelLine.add("if (m==1) Serial.write((byte)15);// 1 for text mode");
  minitelLine.add("}");
  minitelLine.add("void setBackgroundColor(int c) {");
  minitelLine.add("Serial.write((byte)27);");
  minitelLine.add("Serial.write((byte)80 + floor((float)c/2)+(c%2)*4);");
  minitelLine.add("}");
  minitelLine.add("void setTextColor(int c) {");
  minitelLine.add("Serial.write((byte)27);");
  minitelLine.add("Serial.write((byte)64 + floor((float)c/2)+(c%2)*4);");
  minitelLine.add("}");
  String[] result = new String[minitelLine.size()];
  for (int i=0;i<minitelLine.size();i++) {
    result[i]=(String)minitelLine.get(i);
  }
  saveStrings("minitelPicture/minitelPicture.ino", result);
}

void draw() {
}

float getBrightnessOf(PImage in, int x, int y, int w, int h) {
  float bri=0;
  int divi=0;
  for (int pX=x ; pX<min(x+w,in.width) ; pX++) {
    for (int pY=y ; pY<min(y+h,in.height) ; pY++) {
      bri += brightness(in.get(pX, pY));
      divi++;
    }
  }
  bri /= divi;
  bri /= 0xFF;
  return bri;
}

int[] getCharValuesFor(float[][] briV) {
  float minV = 1;
  float maxV = 0;
  for (int x=0 ; x<2 ; x++) {
    for (int y=0 ; y<3 ; y++) {
      if (briV[x][y]<minV) minV = briV[x][y];
      if (briV[x][y]>maxV) maxV = briV[x][y];
    }
  }
  int[] result = new int[3];
  result[0] = floor(minV*8);
  result[1] = floor(maxV*8);
  boolean[][] on = new boolean[2][3];
  for (int x=0 ; x<2 ; x++) {
    for (int y=0 ; y<3 ; y++) {
      if (abs(briV[x][y]-minV)>abs(briV[x][y]-maxV)) on[x][y] = false;
      else on[x][y] = true;
    }
  }
  result[2] = shapeValue(on);
  return result;
}

int shapeValue(boolean[][] p) {
  int value=32;
  if (p[0][0]) value+=32;
  if (p[1][0]) value+=16;
  if (p[0][1]) value+=8;
  if (p[1][1]) value+=4;
  if (p[0][2]) value+=2;
  if (p[1][2]) value+=1;
  return value;
}

