
import processing.serial.*;
Serial myPort;  

import processing.video.*;
import processing.net.*;

Capture video;

boolean enableSerialCom = true;
int delayTime = 0;

int frameNb=0;
int startAtFrame = 100;

void setup() {
  frameRate(25);
  size(800, 480);// only matters for the preview, any size is ok
  video = new Capture(this, 400, 240, 30);// any size is ok
  if (enableSerialCom) myPort = new Serial(this, Serial.list()[0], 1200);
  println(Serial.list()[0]);
}

void draw() {

  if (video.available()) 
  {
    frameNb++;
    println("frame number " + frameNb);
    if (frameNb >= startAtFrame) {
      video.read();

      PImage input = video.get();

      // gets brightness values out of the picture
      float[][] briV = new float[40*2][25*3];
      for (int x=0;x<40*2;x++) {
        for (int y=0;y<24*3;y++) {
          briV[x][y] = getBrightnessOf(input, x*input.width/(40*2), y*input.height/(25*3), input.width/(40*2), input.height/(25*3));
        }
      }

      // finds the good colors and characters
      float[][] bck = new float[40][25];// background colors
      float[][] txt = new float[40][25];// text colors
      float[][] chr = new float[40][25];// characters

      for (int y=0;y<24;y++) {  
        for (int x=0;x<40;x++) {

          // crops a [2][3] brightness section
          // out of the picture
          float[][] thisBriV = new float[2][3];
          for (int x2=0;x2<2;x2++) {
            for (int y2=0;y2<3;y2++) {
              thisBriV[x2][y2] = briV[x*2+x2][y*3+y2];
            }
          }

          // stores the result in the arrays
          int[] thisV = getCharValuesFor(thisBriV);
          bck[x][y] = thisV[0];
          txt[x][y] = thisV[1];
          chr[x][y] = thisV[2];
        }
      }

      // preview on the computer screen
      preview(bck, txt, chr);

      setMode(0);
      delay(delayTime);
      clearScreen();
      delay(delayTime);

      // displays the picture
      for (int y=0;y<24;y++) {  
        for (int x=0;x<40;x++) {
          setBackgroundColor(floor(bck[x][y]));
          delay(delayTime);
          setTextColor(floor(txt[x][y]));
          delay(delayTime);      
          if (enableSerialCom) myPort.write(floor(chr[x][y]));
          delay(delayTime);
        }
      }
    }
  }
}

void preview(float[][] bck, float[][] txt, float[][] chr) {
  // displays an emulated preview of the minitel screen
  noStroke();
  for (int x=0;x<40;x++) {
    for (int y=0;y<24;y++) {
      boolean[][] sh = reverseShapeValue(chr[x][y]);
      for (int x2=0;x2<2;x2++) {
        for (int y2=0;y2<3;y2++) {
          if (sh[x2][y2]) fill(txt[x][y]*0xFF/8);
          else fill(bck[x][y]*0xFF/8);
          rect((float)(x*2+x2)*width/(40*2), (float)(y*3+y2)*height/(24*3), (float)width/(40*2), (float)height/(24*3));
        }
      }
    }
  }
}

float getBrightnessOf(PImage in, int x, int y, int w, int h) {
  float bri=0;
  int divi=0;
  for (int pX=x ; pX<min(x+w,in.width) ; pX++) {
    for (int pY=y ; pY<min(y+h,in.height) ; pY++) {
      bri += brightness(in.get(pX, pY));
      divi++;
    }
  }
  bri /= divi;
  bri /= 0xFF;
  return bri;
}

int[] getCharValuesFor(float[][] briV) {
  // briV is a float[2][3] matrix
  // where each value must be a 0-255 brightness value

  // getCharValuesFor will return a int[3] array where
  // [0] = the color of the background
  // [1] = the color of the text
  // [2] = the character

  float minV = 1;
  float maxV = 0;
  for (int x=0 ; x<2 ; x++) {
    for (int y=0 ; y<3 ; y++) {
      if (briV[x][y]<minV) minV = briV[x][y];
      if (briV[x][y]>maxV) maxV = briV[x][y];
    }
  }
  int[] result = new int[3];
  result[0] = floor(minV*8);
  result[1] = floor(maxV*8);
  boolean[][] on = new boolean[2][3];
  for (int x=0 ; x<2 ; x++) {
    for (int y=0 ; y<3 ; y++) {
      if (abs(briV[x][y]-minV)>abs(briV[x][y]-maxV)) on[x][y] = false;
      else on[x][y] = true;
    }
  }
  result[2] = shapeValue(on);
  return result;
}

int shapeValue(boolean[][] p) {
  int value=32;
  boolean inverted = true;
  if (inverted) {
    if (p[1][2]) value+=32;
    if (p[0][2]) value+=16;
    if (p[1][1]) value+=8;
    if (p[0][1]) value+=4;
    if (p[1][0]) value+=2;
    if (p[0][0]) value+=1;
  }
  else {
    if (p[0][0]) value+=32;
    if (p[1][0]) value+=16;
    if (p[0][1]) value+=8;
    if (p[1][1]) value+=4;
    if (p[0][2]) value+=2;
    if (p[1][2]) value+=1;
  }
  return value;
}

boolean[][] reverseShapeValue(float value) {
  boolean[][] r = new boolean[2][3];
  value-=32;
  int p=5;
  for (int x=0;x<2;x++) {
    for (int y=0;y<3;y++) {
      if (value>=pow(2, p)) {
        value-=pow(2, p);
        r[x][y]=true;
      }
      else {
        r[x][y]=false;
      }
      p--;
    }
  }
  return r;
}

void moveCursor(int x, int y) {
  if (enableSerialCom) {  
    x = constrain(x, -1, 1);
    y = constrain(y, -1, 1);
    if (x ==  1) myPort.write((byte)9);
    if (x == -1) myPort.write((byte)8);
    if (y ==  1) myPort.write((byte)10);
    if (y == -1) myPort.write((byte)11);
  }
}

void fontMagnify(boolean x, boolean y) {
  if (enableSerialCom) {  
    myPort.write((byte)27);
    if (x) {
      if (y) myPort.write((byte)79);
      else myPort.write((byte)78);
    } 
    else {
      if (y) myPort.write((byte)77);
      else myPort.write((byte)76);
    }
  }
}

void clearScreen() {
  if (enableSerialCom) myPort.write((byte)12);
}

void setMode(int m) {
  if (enableSerialCom) {
    if (m==0) myPort.write((byte)14);// 0 for graphical mode
    if (m==1) myPort.write((byte)15);// 1 for text mode
  }
}

void setBackgroundColor(int c) {
  if (enableSerialCom) {
    myPort.write((byte)27);
    myPort.write((byte)80 + floor((float)c/2)+(c%2)*4);
  }
}

void setTextColor(int c) {
  if (enableSerialCom) {
    myPort.write((byte)27);
    myPort.write((byte)64 + floor((float)c/2)+(c%2)*4);
  }
}

void writeStatic(int i) {
  if (enableSerialCom) {
    myPort.write(i);
    myPort.write((byte)8);
  }
}

int randomShape() {
  int cur = floor(random(100));
  boolean[][] v = new boolean[2][3];
  for (int x=0;x<2;x++) {
    for (int y=0;y<3;y++) {
      if (cur%23<10) v[x][y]=false;
      else v[x][y]=true;
      cur++;
    }
  }
  return shapeValue(v);
}

void blinking(boolean b) {
  if (enableSerialCom) {
    myPort.write((byte)27);
    if (b) myPort.write((byte)72);
    else myPort.write((byte)73);
  }
}