/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Envelope;
import beads.Gain;
import beads.KillTrigger;
import beads.UGen;

public class ADSR
extends UGen {
    private Envelope env;
    private Gain gain;

    public ADSR(AudioContext context, UGen src, float ... adsr) {
        this(context, src.getOuts(), adsr);
        this.addInput(src);
    }

    public ADSR(UGen src, float ... adsr) {
        this(ADSR.getDefaultContext(), src, adsr);
    }

    public ADSR(AudioContext context, int inouts, float ... adsr) {
        super(context, inouts, inouts);
        this.env = new Envelope(context, 0.0f);
        this.gain = new Gain(context, inouts, this.env);
        for (int i = 0; i < adsr.length - 1; i += 2) {
            this.env.addSegment(adsr[i], adsr[i + 1]);
        }
        this.env.addSegment(0.0f, adsr[adsr.length - 1], new KillTrigger(this));
    }

    public ADSR(int inouts, float ... adsr) {
        this(ADSR.getDefaultContext(), inouts, adsr);
    }

    @Override
    public void calculateBuffer() {
        this.env.update();
        this.gain.update();
        for (int i = 0; i < this.ins; ++i) {
            this.bufOut[i] = this.gain.getOutBuffer(i);
        }
    }

    @Override
    public synchronized void addInput(int inputIndex, UGen sourceUGen, int sourceOutputIndex) {
        this.gain.addInput(inputIndex, sourceUGen, sourceOutputIndex);
    }

    @Override
    public synchronized boolean removeConnection(int inputChannel, UGen sourceUGen, int sourceOutputChannel) {
        return this.gain.removeConnection(inputChannel, sourceUGen, sourceOutputChannel);
    }
}

