/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContextStopTrigger;
import beads.AudioIO;
import beads.Bead;
import beads.DelayTrigger;
import beads.Gain;
import beads.IOAudioFormat;
import beads.NonrealtimeIO;
import beads.RecordToSample;
import beads.Sample;
import beads.TimeStamp;
import beads.UGen;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AudioContext {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private static AudioContext defaultContext;
    private AudioIO audioIO;
    private IOAudioFormat audioFormat;
    private boolean stopped;
    public final Gain out;
    private long timeStep;
    private boolean logTime;
    private int bufferSizeInFrames;
    private int maxReserveBufs;
    private ArrayList<float[]> bufferStore;
    private int bufStoreIndex;
    private float[] zeroBuf;
    private long nanoLeap;
    private boolean lastFrameGood;
    private final ConcurrentLinkedQueue<Bead> beforeFrameQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> afterFrameQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> beforeEveryFrameList = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Bead> afterEveryFrameList = new ConcurrentLinkedQueue();

    public AudioContext() {
        this(512);
    }

    public AudioContext(int bufferSize) {
        AudioIO ioSystem = null;
        try {
            Class<?> javaSoundAudioIOClass = Class.forName("beads.JavaSoundAudioIO");
            Constructor<?> noArgsConstructor = javaSoundAudioIOClass.getConstructor(new Class[0]);
            ioSystem = (AudioIO)noArgsConstructor.newInstance(new Object[0]);
            System.out.println("AudioContext : no AudioIO specified, using default => " + javaSoundAudioIOClass.getName() + ".");
        }
        catch (Exception e) {
            System.out.println("AudioContext : warning : unable to find default (JavaSound) AudioIO.");
            System.out.println("AudioContext : warning : reverting to NonrealtimeIO. You can still process audio but don't expect to hear anything.");
            ioSystem = new NonrealtimeIO();
        }
        IOAudioFormat audioFormat = AudioContext.defaultAudioFormat(2, 2);
        this.audioIO = ioSystem;
        this.audioIO.context = this;
        this.audioFormat = audioFormat;
        this.setBufferSize(bufferSize);
        this.logTime = false;
        this.maxReserveBufs = 50;
        this.stopped = true;
        this.out = new Gain(this, audioFormat.outputs);
        this.audioIO.prepare();
    }

    public AudioContext(AudioIO ioSystem) {
        this(ioSystem, 512, AudioContext.defaultAudioFormat(2, 2));
    }

    public AudioContext(AudioIO ioSystem, int bufferSizeInFrames) {
        this(ioSystem, bufferSizeInFrames, AudioContext.defaultAudioFormat(2, 2));
    }

    public AudioContext(AudioIO ioSystem, int bufferSizeInFrames, IOAudioFormat audioFormat) {
        this.audioIO = ioSystem;
        this.audioIO.context = this;
        this.audioFormat = audioFormat;
        this.setBufferSize(bufferSizeInFrames);
        this.logTime = false;
        this.maxReserveBufs = 50;
        this.stopped = true;
        this.out = new Gain(this, audioFormat.outputs);
        this.audioIO.prepare();
    }

    public UGen getAudioInput(int[] channels) {
        return this.audioIO.getAudioInput(channels);
    }

    public UGen getAudioInput() {
        int[] chans = new int[this.audioFormat.inputs];
        for (int i = 0; i < chans.length; ++i) {
            chans[i] = i + 1;
        }
        return this.audioIO.getAudioInput(chans);
    }

    private void setupBufs() {
        this.bufferStore = new ArrayList();
        while (this.bufferStore.size() < this.maxReserveBufs) {
            this.bufferStore.add(new float[this.bufferSizeInFrames]);
        }
        this.zeroBuf = new float[this.bufferSizeInFrames];
    }

    protected void update() {
        try {
            this.bufStoreIndex = 0;
            Arrays.fill(this.zeroBuf, 0.0f);
            this.sendBeforeFrameMessages();
            this.out.update();
            this.sendAfterFrameMessages();
            ++this.timeStep;
            if (Thread.interrupted()) {
                System.out.println("Thread interrupted");
            }
            if (this.logTime && this.timeStep % 100L == 0L) {
                System.out.println(this.samplesToMs(this.timeStep * (long)this.bufferSizeInFrames) / 1000.0 + " (seconds)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized float[] getBuf() {
        if (this.bufStoreIndex < this.bufferStore.size()) {
            return this.bufferStore.get(this.bufStoreIndex++);
        }
        float[] buf = new float[this.bufferSizeInFrames];
        this.bufferStore.add(buf);
        ++this.bufStoreIndex;
        return buf;
    }

    float[] getCleanBuf() {
        float[] buf = this.getBuf();
        Arrays.fill(buf, 0.0f);
        return buf;
    }

    float[] getZeroBuf() {
        return this.zeroBuf;
    }

    private void runNonRealTime() {
        if (this.stopped) {
            this.stopped = false;
            this.reset();
            while (this.out != null && !this.stopped) {
                this.bufStoreIndex = 0;
                Arrays.fill(this.zeroBuf, 0.0f);
                if (!this.out.isPaused()) {
                    this.sendBeforeFrameMessages();
                    this.out.update();
                    this.sendAfterFrameMessages();
                }
                ++this.timeStep;
                if (!this.logTime || this.timeStep % 100L != 0L) continue;
                System.out.println(this.samplesToMs(this.timeStep * (long)this.bufferSizeInFrames) / 1000.0 + " (seconds)");
            }
        }
    }

    public void runForNMillisecondsNonRealTime(double n) {
        DelayTrigger dt = new DelayTrigger(this, n, (Bead)new AudioContextStopTrigger(this));
        this.out.addDependent(dt);
        this.runNonRealTime();
    }

    private void setBufferSize(int bufferSize) {
        this.bufferSizeInFrames = bufferSize;
        this.setupBufs();
    }

    public int getBufferSize() {
        return this.bufferSizeInFrames;
    }

    public float getSampleRate() {
        return this.audioFormat.sampleRate;
    }

    public IOAudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public IOAudioFormat getAudioFormat(int inputs, int outputs) {
        IOAudioFormat newFormat = new IOAudioFormat(this.audioFormat.sampleRate, this.audioFormat.bitDepth, inputs, outputs);
        return newFormat;
    }

    public static IOAudioFormat defaultAudioFormat(int inputs, int outputs) {
        return new IOAudioFormat(44100.0f, 16, inputs, outputs, true, true);
    }

    public void postAudioFormatInfo() {
        System.out.println("Sample Rate: " + this.audioFormat.sampleRate);
        System.out.println("Inputs: " + this.audioFormat.inputs);
        System.out.println("Outputs: " + this.audioFormat.outputs);
        System.out.println("Bit Depth: " + this.audioFormat.bitDepth);
        System.out.println("Big Endian: " + this.audioFormat.bigEndian);
        System.out.println("Signed: " + this.audioFormat.signed);
    }

    public static void printCallChain(UGen current, int depth) {
        Set<UGen> children = current.getConnectedInputs();
        for (int i = 0; i < depth; ++i) {
            System.out.print("  ");
        }
        System.out.println("- " + current);
        for (UGen child : children) {
            AudioContext.printCallChain(child, depth + 1);
        }
    }

    public void printCallChain() {
        AudioContext.printCallChain(this.out, 0);
    }

    public double msToSamples(double msTime) {
        return msTime * ((double)this.audioFormat.sampleRate / 1000.0);
    }

    public double samplesToMs(double sampleTime) {
        return sampleTime / (double)this.audioFormat.sampleRate * 1000.0;
    }

    public long getTimeStep() {
        return this.timeStep;
    }

    public TimeStamp generateTimeStamp(int index) {
        return new TimeStamp(this, this.timeStep, index);
    }

    public double getTime() {
        return this.samplesToMs(this.getTimeStep() * (long)this.getBufferSize());
    }

    public void logTime(boolean logTime) {
        this.logTime = logTime;
    }

    public void record(double timeMS, String filename) throws Exception {
        Sample s = new Sample(timeMS, this.audioFormat.outputs, this.audioFormat.sampleRate);
        try {
            RecordToSample r = new RecordToSample(this, s);
            r.addInput(this.out);
            this.out.addDependent(r);
            r.start();
            r.setKillListener(new AudioContextStopTrigger(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.isRunning()) {
        }
        s.write(filename);
    }

    public void quickie(UGen ugen) {
        this.out.addInput(ugen);
        this.start();
    }

    public void start() {
        if (this.stopped) {
            this.nanoLeap = (long)(1.0E9f * ((float)this.bufferSizeInFrames / this.audioFormat.sampleRate));
            this.lastFrameGood = true;
            this.reset();
            this.stopped = false;
            this.audioIO.start();
        }
    }

    public void reset() {
        this.timeStep = 0L;
    }

    public void stop() {
        this.stopped = true;
        this.audioIO.stop();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public AudioIO getAudioIO() {
        return this.audioIO;
    }

    public AudioContext invokeAfterFrame(Bead target) {
        this.afterFrameQueue.offer(target);
        return this;
    }

    public AudioContext invokeAfterEveryFrame(Bead target) {
        this.afterEveryFrameList.offer(target);
        return this;
    }

    public boolean stopInvokingAfterEveryFrame(Bead target) {
        return this.afterEveryFrameList.remove(target);
    }

    public AudioContext invokeBeforeFrame(Bead target) {
        this.beforeFrameQueue.add(target);
        return this;
    }

    public AudioContext invokeBeforeEveryFrame(Bead target) {
        this.beforeEveryFrameList.offer(target);
        return this;
    }

    public boolean stopInvokingBeforeEveryFrame(Bead target) {
        return this.beforeEveryFrameList.remove(target);
    }

    private void sendBeforeFrameMessages() {
        Bead target;
        while ((target = this.beforeFrameQueue.poll()) != null) {
            target.message(null);
        }
        for (Bead bead : this.beforeEveryFrameList) {
            bead.message(null);
        }
    }

    private void sendAfterFrameMessages() {
        Bead target;
        while ((target = this.afterFrameQueue.poll()) != null) {
            target.message(null);
        }
        for (Bead bead : this.afterEveryFrameList) {
            bead.message(null);
        }
    }

    public static AudioContext getDefaultContext() {
        if (defaultContext == null) {
            defaultContext = new AudioContext();
        }
        return defaultContext;
    }

    public static void setDefaultContext(AudioContext newContext) {
        defaultContext = newContext;
    }
}

