/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.DataBead;
import beads.DataBeadReceiver;
import beads.IIRFilter;
import beads.Static;
import beads.UGen;

public class LPRezFilter
extends IIRFilter
implements DataBeadReceiver {
    protected float freq = 100.0f;
    protected float res = 0.5f;
    protected float _2pi_over_sr;
    protected float cosw = 0.0f;
    protected UGen freqUGen;
    protected UGen resUGen;
    protected float a1;
    protected float a2;
    protected float b0;
    private float y1 = 0.0f;
    private float y2 = 0.0f;
    private float[] y1m;
    private float[] y2m;
    private int channels;
    protected boolean isFreqStatic;
    protected boolean isResStatic;

    public LPRezFilter(AudioContext con) {
        this(con, 1);
    }

    public LPRezFilter() {
        this(LPRezFilter.getDefaultContext());
    }

    public LPRezFilter(AudioContext con, int channels) {
        super(con, channels, channels);
        this._2pi_over_sr = (float)(Math.PI * 2 / (double)con.getSampleRate());
        this.channels = super.getOuts();
        this.y1m = new float[this.channels];
        this.y2m = new float[this.channels];
        this.setFrequency(this.freq).setRes(this.res);
    }

    public LPRezFilter(int channels) {
        this(LPRezFilter.getDefaultContext(), channels);
    }

    public LPRezFilter(AudioContext con, float freq, float res) {
        this(con, 1, freq, res);
    }

    public LPRezFilter(float freq, float res) {
        this(LPRezFilter.getDefaultContext(), freq, res);
    }

    public LPRezFilter(AudioContext con, UGen freq, float res) {
        this(con, 1, freq, res);
    }

    public LPRezFilter(UGen freq, float res) {
        this(LPRezFilter.getDefaultContext(), freq, res);
    }

    public LPRezFilter(AudioContext con, float freq, UGen res) {
        this(con, 1, freq, res);
    }

    public LPRezFilter(float freq, UGen res) {
        this(LPRezFilter.getDefaultContext(), freq, res);
    }

    public LPRezFilter(AudioContext con, UGen freq, UGen res) {
        this(con, 1, freq, res);
    }

    public LPRezFilter(UGen freq, UGen res) {
        this(LPRezFilter.getDefaultContext(), freq, res);
    }

    public LPRezFilter(AudioContext con, int channels, float freq, float res) {
        this(con, channels);
        this.setFrequency(freq).setRes(res);
    }

    public LPRezFilter(int channels, float freq, float res) {
        this(LPRezFilter.getDefaultContext(), channels, freq, res);
    }

    public LPRezFilter(AudioContext con, int channels, UGen freq, float res) {
        this(con, channels);
        this.setFrequency(freq).setRes(res);
    }

    public LPRezFilter(int channels, UGen freq, float res) {
        this(LPRezFilter.getDefaultContext(), channels, freq, res);
    }

    public LPRezFilter(AudioContext con, int channels, float freq, UGen res) {
        this(con, channels);
        this.setFrequency(freq).setRes(res);
    }

    public LPRezFilter(int channels, float freq, UGen res) {
        this(LPRezFilter.getDefaultContext(), channels, freq, res);
    }

    public LPRezFilter(AudioContext con, int channels, UGen freq, UGen res) {
        this(con, channels);
        this.setFrequency(freq).setRes(res);
    }

    public LPRezFilter(int channels, UGen freq, UGen res) {
        this(LPRezFilter.getDefaultContext(), channels, freq, res);
    }

    protected void calcVals() {
        this.a1 = -2.0f * this.res * this.cosw;
        this.a2 = this.res * this.res;
        this.b0 = 1.0f + this.a1 + this.a2;
    }

    @Override
    public void calculateBuffer() {
        block32: {
            block31: {
                if (this.channels != 1) break block31;
                float[] bi = this.bufIn[0];
                float[] bo = this.bufOut[0];
                if (this.isFreqStatic && this.isResStatic) {
                    bo[0] = bi[0] * this.b0 - this.a1 * this.y1 - this.a2 * this.y2;
                    bo[1] = bi[1] * this.b0 - this.a1 * bo[0] - this.a2 * this.y1;
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        bo[currsamp] = bi[currsamp] * this.b0 - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2];
                    }
                } else {
                    float f;
                    float f2;
                    this.freqUGen.update();
                    this.resUGen.update();
                    this.freq = this.freqUGen.getValue(0, 0);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, 0);
                    if (f2 > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    bo[0] = bi[0] * this.b0 - this.a1 * this.y1 - this.a2 * this.y2;
                    this.freq = this.freqUGen.getValue(0, 1);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, 1);
                    if (f > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    bo[1] = bi[1] * this.b0 - this.a1 * bo[0] - this.a2 * this.y1;
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        float f3;
                        this.freq = this.freqUGen.getValue(0, currsamp);
                        this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                        this.res = this.resUGen.getValue(0, currsamp);
                        if (f3 > 0.999999f) {
                            this.res = 0.999999f;
                        } else if (this.res < 0.0f) {
                            this.res = 0.0f;
                        }
                        this.calcVals();
                        bo[currsamp] = bi[currsamp] * this.b0 - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2];
                    }
                }
                this.y2 = bo[this.bufferSize - 2];
                this.y1 = bo[this.bufferSize - 1];
                if (!Float.isNaN(this.y1)) break block32;
                this.reset();
                break block32;
            }
            if (this.isFreqStatic && this.isResStatic) {
                for (int i = 0; i < this.channels; ++i) {
                    float[] bi = this.bufIn[i];
                    float[] bo = this.bufOut[i];
                    bo[0] = bi[0] * this.b0 - this.a1 * this.y1m[i] - this.a2 * this.y2m[i];
                    bo[1] = bi[1] * this.b0 - this.a1 * bo[0] - this.a2 * this.y1m[i];
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        bo[currsamp] = bi[currsamp] * this.b0 - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2];
                    }
                    this.y2m[i] = bo[this.bufferSize - 2];
                    this.y1m[i] = bo[this.bufferSize - 1];
                    if (!Float.isNaN(this.y1m[i])) continue;
                    this.reset();
                }
            } else {
                float f;
                int i;
                float f4;
                this.freqUGen.update();
                this.resUGen.update();
                this.freq = this.freqUGen.getValue(0, 0);
                this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                this.res = this.resUGen.getValue(0, 0);
                if (f4 > 0.999999f) {
                    this.res = 0.999999f;
                } else if (this.res < 0.0f) {
                    this.res = 0.0f;
                }
                this.calcVals();
                for (i = 0; i < this.channels; ++i) {
                    this.bufOut[i][0] = this.bufIn[i][0] * this.b0 - this.a1 * this.y1m[i] - this.a2 * this.y2m[i];
                }
                this.freq = this.freqUGen.getValue(0, 1);
                this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                this.res = this.resUGen.getValue(0, 1);
                if (f > 0.999999f) {
                    this.res = 0.999999f;
                } else if (this.res < 0.0f) {
                    this.res = 0.0f;
                }
                this.calcVals();
                for (i = 0; i < this.channels; ++i) {
                    this.bufOut[i][1] = this.bufIn[i][1] * this.b0 - this.a1 * this.bufOut[i][0] - this.a2 * this.y1m[i];
                }
                for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                    float f5;
                    this.freq = this.freqUGen.getValue(0, currsamp);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, currsamp);
                    if (f5 > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    for (int i2 = 0; i2 < this.channels; ++i2) {
                        this.bufOut[i2][currsamp] = this.bufIn[i2][currsamp] * this.b0 - this.a1 * this.bufOut[i2][currsamp - 1] - this.a2 * this.bufOut[i2][currsamp - 2];
                    }
                }
                for (i = 0; i < this.channels; ++i) {
                    this.y2m[i] = this.bufOut[i][this.bufferSize - 2];
                    this.y1m[i] = this.bufOut[i][this.bufferSize - 1];
                    if (!Float.isNaN(this.y1m[i])) continue;
                    this.reset();
                }
            }
        }
    }

    public void reset() {
        this.y1 = 0.0f;
        this.y2 = 0.0f;
        for (int i = 0; i < this.channels; ++i) {
            this.y1m[i] = 0.0f;
            this.y2m[i] = 0.0f;
        }
    }

    public float getFrequency() {
        return this.freq;
    }

    public LPRezFilter setFrequency(float freq) {
        this.freq = freq;
        if (this.isFreqStatic) {
            this.freqUGen.setValue(freq);
        } else {
            this.freqUGen = new Static(this.context, freq);
            this.isFreqStatic = true;
        }
        this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
        this.calcVals();
        return this;
    }

    public LPRezFilter setFrequency(UGen freqUGen) {
        if (freqUGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = freqUGen;
            freqUGen.update();
            this.freq = freqUGen.getValue();
            this.isFreqStatic = false;
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public LPRezFilter setFreq(float freq) {
        return this.setFrequency(freq);
    }

    @Deprecated
    public LPRezFilter setFreq(UGen freqUGen) {
        return this.setFrequency(freqUGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public float getRes() {
        return this.res;
    }

    public LPRezFilter setRes(float r) {
        this.res = r > 0.999999f ? 0.999999f : (r < 0.0f ? 0.0f : r);
        if (this.isResStatic) {
            this.resUGen.setValue(this.res);
        } else {
            this.resUGen = new Static(this.context, this.res);
            this.isResStatic = true;
        }
        this.calcVals();
        return this;
    }

    public LPRezFilter setRes(UGen r) {
        if (r == null) {
            this.setRes(this.res);
        } else {
            this.resUGen = r;
            r.update();
            this.res = r.getValue();
            this.isResStatic = false;
        }
        return this;
    }

    public UGen getResUGen() {
        if (this.isResStatic) {
            return null;
        }
        return this.resUGen;
    }

    public LPRezFilter setParams(DataBead paramBead) {
        if (paramBead != null) {
            Object o = paramBead.get("frequency");
            if (o != null) {
                if (o instanceof UGen) {
                    this.setFrequency((UGen)o);
                } else {
                    this.setFrequency(paramBead.getFloat("frequency", this.freq));
                }
            }
            if ((o = paramBead.get("resonance")) != null) {
                if (o instanceof UGen) {
                    this.setRes((UGen)o);
                } else {
                    this.setRes(paramBead.getFloat("resonance", this.res));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isFreqStatic) {
            db.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            db.put("frequency", (Object)this.freqUGen);
        }
        if (this.isResStatic) {
            db.put("resonance", (Object)Float.valueOf(this.res));
        } else {
            db.put("resonance", (Object)this.resUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("frequency", (Object)Float.valueOf(this.freq));
        db.put("resonance", (Object)Float.valueOf(this.res));
        return db;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        this.setParams(db);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float freq) {
        return LPRezFilter.calculateFilterResponse(new float[]{this.b0}, new float[]{1.0f, this.a1, this.a2}, freq, this.context.getSampleRate());
    }
}

