/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.FeatureExtractor;
import beads.TimeStamp;

public class MelSpectrum
extends FeatureExtractor<float[], float[]> {
    public static final float LOG10 = (float)Math.log(10.0);
    private final float sampleRate;
    private int bufferSize;
    private double[] melCenter;
    private double[] melWidth;
    private double[] melOfLin;
    private double hardMax;

    public MelSpectrum(float sampleRate, int numCoeffs) {
        this.sampleRate = sampleRate;
        this.setNumberOfFeatures(numCoeffs);
        this.hardMax = 8000.0;
    }

    private void setup() {
        int i;
        int twiceBufferSize = this.bufferSize * 2;
        this.features = new float[this.numFeatures];
        this.melCenter = new double[this.numFeatures + 2];
        this.melWidth = new double[this.numFeatures + 2];
        double melMin = MelSpectrum.lin2mel(0.0);
        double melMax = MelSpectrum.lin2mel(this.hardMax < (double)(this.sampleRate / 2.0f) ? this.hardMax : (double)(this.sampleRate / 2.0f));
        double hzPerBin = this.sampleRate / 2.0f / (float)twiceBufferSize;
        for (i = 0; i < this.numFeatures + 2; ++i) {
            this.melCenter[i] = melMin + (double)i * (melMax - melMin) / (double)(this.numFeatures + 1);
        }
        for (i = 0; i < this.numFeatures + 1; ++i) {
            this.melWidth[i] = this.melCenter[i + 1] - this.melCenter[i];
            double linbinwidth = (MelSpectrum.mel2lin(this.melCenter[i + 1]) - MelSpectrum.mel2lin(this.melCenter[i])) / hzPerBin;
            if (linbinwidth < 1.0) {
                this.melWidth[i] = MelSpectrum.lin2mel(MelSpectrum.mel2lin(this.melCenter[i]) + hzPerBin) - this.melCenter[i];
            }
            if (this.melWidth[i] != 0.0) continue;
            System.out.println("zero melwidth");
        }
        this.melOfLin = new double[twiceBufferSize];
        for (i = 0; i < twiceBufferSize; ++i) {
            this.melOfLin[i] = MelSpectrum.lin2mel((float)i * this.sampleRate / (float)(2 * twiceBufferSize));
            if (!Double.isInfinite(this.melOfLin[i])) continue;
            System.out.println("infinte meloflin");
        }
        this.featureDescriptions = new String[this.numFeatures];
        for (i = 0; i < this.numFeatures; ++i) {
            this.featureDescriptions[i] = i < 9 ? "mel0" + (i + 1) : "mel" + (i + 1);
        }
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, float[] powerSpectrum) {
        if (powerSpectrum.length != this.bufferSize) {
            this.bufferSize = powerSpectrum.length;
            this.setup();
        }
        float[] linSpec = new float[powerSpectrum.length];
        for (int band = 0; band < linSpec.length; ++band) {
            linSpec[band] = powerSpectrum[band];
        }
        for (int bin = 0; bin < ((float[])this.features).length; ++bin) {
            ((float[])this.features)[bin] = 0.0f;
            for (int i = 0; i < linSpec.length; ++i) {
                double weight = 1.0 - Math.abs(this.melOfLin[i] - this.melCenter[bin]) / this.melWidth[bin];
                if (!(weight > 0.0)) continue;
                float[] fArray = (float[])this.features;
                int n = bin;
                fArray[n] = (float)((double)fArray[n] + weight * (double)linSpec[i]);
            }
            ((float[])this.features)[bin] = Math.max(0.0f, (float)(10.0 * Math.log(((float[])this.features)[bin]) / (double)LOG10));
        }
        this.forward(startTime, endTime);
    }

    @Override
    public void setNumberOfFeatures(int numFeatures) {
        super.setNumberOfFeatures(numFeatures);
        this.bufferSize = -1;
    }

    private static double lin2mel(double fq) {
        return 1127.0 * Math.log(1.0 + fq / 700.0);
    }

    private static double mel2lin(double mel) {
        return 700.0 * (Math.exp(mel / 1127.0) - 1.0);
    }

    public double getFreqForBin(int bin) {
        if (this.melCenter != null) {
            return MelSpectrum.mel2lin(this.melCenter[bin]);
        }
        return Double.NaN;
    }

    public int getBinForFreq(double freq) {
        if (this.melCenter != null) {
            int i;
            double mel = MelSpectrum.lin2mel(freq);
            for (i = 0; i < this.melCenter.length && !(mel <= this.melCenter[i]); ++i) {
            }
            if (i >= this.numFeatures) {
                return this.numFeatures - 1;
            }
            return i;
        }
        return 0;
    }
}

