/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Bead;
import beads.DataBead;
import beads.DataBeadReceiver;
import beads.UGen;
import beads.UGenChain;

public class MultiWrapper
extends UGenChain
implements DataBeadReceiver {
    private UGen[] ugens;
    private int channels;
    private int insPerChannel;
    private int outsPerChannel;

    public MultiWrapper(AudioContext context, int channels) {
        this(context, channels, 1, 1);
    }

    public MultiWrapper(int channels) {
        this(MultiWrapper.getDefaultContext(), channels);
    }

    private MultiWrapper(AudioContext context, int numIns, int numOuts) {
        super(context, numIns, numOuts);
    }

    private MultiWrapper(int numIns, int numOuts) {
        this(MultiWrapper.getDefaultContext(), numIns, numOuts);
    }

    public MultiWrapper(AudioContext context, int channels, int insPerChannel, int outsPerChannel) {
        this(context, channels * insPerChannel, channels * outsPerChannel);
        this.insPerChannel = insPerChannel;
        this.outsPerChannel = outsPerChannel;
        this.channels = channels;
        this.ugens = new UGen[channels];
        for (int i = 0; i < channels; ++i) {
            this.ugens[i] = this.buildUGens(i);
        }
        this.setupUGens();
    }

    public MultiWrapper(int channels, int insPerChannel, int outsPerChannel) {
        this(MultiWrapper.getDefaultContext(), channels, insPerChannel, outsPerChannel);
    }

    public MultiWrapper(AudioContext context, UGen[] ugens, int insPerChannel, int outsPerChannel) {
        this(context, ugens.length * insPerChannel, ugens.length * outsPerChannel);
        this.insPerChannel = insPerChannel;
        this.outsPerChannel = outsPerChannel;
        this.channels = ugens.length;
        this.ugens = ugens;
        this.setupUGens();
    }

    public MultiWrapper(UGen[] ugens, int insPerChannel, int outsPerChannel) {
        this(MultiWrapper.getDefaultContext(), ugens, insPerChannel, outsPerChannel);
    }

    private void setupUGens() {
        for (int i = 0; i < this.channels; ++i) {
            int j;
            for (j = 0; j < this.insPerChannel; ++j) {
                if (j >= this.ugens[i].getIns()) continue;
                this.drawFromChainInput(i * this.insPerChannel + j, this.ugens[i], j);
            }
            for (j = 0; j < this.outsPerChannel; ++j) {
                if (j >= this.ugens[i].getOuts()) continue;
                this.addToChainOutput(i * this.outsPerChannel + j, this.ugens[i], j);
            }
        }
    }

    public UGen buildUGens(int channelIndex) {
        return new UGen(this.context, 1, 0){

            @Override
            public void calculateBuffer() {
            }
        };
    }

    public void addInput(int channelIndex, int channelUGenInput, UGen sourceUGen, int sourceOutput) {
        this.addInput(channelIndex * this.insPerChannel + channelUGenInput, sourceUGen, sourceOutput);
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        for (int i = 0; i < this.channels; ++i) {
            if (this.ugens[i] instanceof DataBeadReceiver) {
                ((DataBeadReceiver)((Object)this.ugens[i])).sendData(db);
                continue;
            }
            this.ugens[i].message(db);
        }
        return this;
    }

    public DataBeadReceiver sendData(int channel, DataBead db) {
        for (int i = 0; i < this.channels; ++i) {
            if (this.ugens[i] instanceof DataBeadReceiver) {
                ((DataBeadReceiver)((Object)this.ugens[i])).sendData(db);
                continue;
            }
            this.ugens[i].message(db);
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.sendData((DataBead)message);
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.ugens[i].message(message);
            }
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public int getInsPerChannel() {
        return this.insPerChannel;
    }

    public int getOutsPerChannel() {
        return this.outsPerChannel;
    }
}

