/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.AudioUtils;
import beads.UGen;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.AudioSystemShadow;
import org.tritonus.share.sampled.file.AudioOutputStream;

public class RecordToFile
extends UGen {
    private static final boolean DEBUG = false;
    private AudioOutputStream audioOutputStream;
    private AudioFormat audioFormat;

    public RecordToFile(AudioContext context, int numberOfChannels, File file, AudioFileFormat.Type type) throws IOException {
        super(context, numberOfChannels, 0);
        if (type != AudioFileFormat.Type.WAVE) {
            System.out.printf("RecordToFile: AudioFileFormat.%s is unsupported. (Only WAVE is currently supported.) \nBeads will continue to use the type specified but it may not output sensible audio data.\n", type.toString());
        }
        this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, context.getSampleRate(), 16, this.getIns(), 2 * this.getIns(), context.getSampleRate(), false);
        this.audioOutputStream = AudioSystemShadow.getAudioOutputStream((AudioFileFormat.Type)type, (AudioFormat)this.audioFormat, (long)-1L, (File)file);
    }

    public RecordToFile(int numberOfChannels, File file, AudioFileFormat.Type type) throws IOException {
        this(RecordToFile.getDefaultContext(), numberOfChannels, file, type);
    }

    public RecordToFile(AudioContext context, int numberOfChannels, File file) throws IOException {
        this(context, numberOfChannels, file, AudioFileFormat.Type.WAVE);
    }

    public RecordToFile(int numberOfChannels, File file) throws IOException {
        this(RecordToFile.getDefaultContext(), numberOfChannels, file);
    }

    @Override
    public void calculateBuffer() {
        int length = this.bufIn[0].length;
        byte[] bytes = new byte[this.getIns() * length * 2];
        if (this.getIns() > 1) {
            float[] interleaved = new float[this.getIns() * length];
            AudioUtils.interleave(this.bufIn, this.getIns(), length, 0, interleaved);
            AudioUtils.floatToByte(bytes, interleaved, false);
        } else {
            AudioUtils.floatToByte(bytes, this.bufIn[0], false);
        }
        try {
            int interleaved = this.audioOutputStream.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void kill() {
        super.kill();
        try {
            this.audioOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

