/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.FFT;
import beads.FeatureExtractor;
import beads.TimeStamp;

public class SpectralDifference
extends FeatureExtractor<Float, float[]> {
    private float[] previousSpectrum;
    private float minFreq;
    private float maxFreq;
    private float sampleRate;
    private DifferenceType differenceType = DifferenceType.POSITIVEMEANDIFFERENCE;
    private int lastBlockSize = 0;
    private int minBin;
    private int maxBin;

    public SpectralDifference(float samplerate) {
        this(samplerate, 0.0f, samplerate);
    }

    public SpectralDifference(float samplerate, float minf, float maxf) {
        this.minFreq = minf;
        this.maxFreq = maxf;
        this.sampleRate = samplerate;
    }

    public void setFreqWindow(float minf, float maxf) {
        this.minFreq = minf;
        this.maxFreq = maxf;
    }

    public void setDifferenceType(DifferenceType dt) {
        this.differenceType = dt;
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, float[] spectrum) {
        int numBins = this.maxBin - this.minBin;
        if (this.lastBlockSize != spectrum.length) {
            this.calcMaxAndMinBin(spectrum.length);
            numBins = this.maxBin - this.minBin;
            if (numBins > 0) {
                this.previousSpectrum = new float[numBins];
            }
            this.lastBlockSize = spectrum.length;
        }
        if (numBins > 0) {
            switch (this.differenceType) {
                case POSITIVERMS: {
                    this.features = Float.valueOf(this.positiveRms(spectrum, this.minBin, this.previousSpectrum, 0, numBins));
                    break;
                }
                case RMS: {
                    this.features = Float.valueOf(this.rms(spectrum, this.minBin, this.previousSpectrum, 0, numBins));
                    break;
                }
                case POSITIVEMEANDIFFERENCE: {
                    this.features = Float.valueOf(this.positiveMeanDifference(spectrum, this.minBin, this.previousSpectrum, 0, numBins));
                    break;
                }
                case MEANDIFFERENCE: {
                    this.features = Float.valueOf(this.meanDifference(spectrum, this.minBin, this.previousSpectrum, 0, numBins));
                }
            }
            System.arraycopy(spectrum, this.minBin, this.previousSpectrum, 0, numBins);
        }
        this.forward(startTime, endTime);
    }

    private float rms(float[] arr1, int i1, float[] arr2, int i2, int length) {
        float value = 0.0f;
        for (int i = 0; i < length; ++i) {
            float thisDiff = arr1[i1 + i] - arr2[i2 + i];
            value += thisDiff * thisDiff;
        }
        return (float)Math.sqrt(value / (float)length);
    }

    private float positiveRms(float[] arr1, int i1, float[] arr2, int i2, int length) {
        float value = 0.0f;
        for (int i = 0; i < length; ++i) {
            float thisDiff = arr1[i1 + i] - arr2[i2 + i];
            if (!(thisDiff >= 0.0f)) continue;
            value += thisDiff * thisDiff;
        }
        return (float)Math.sqrt(value / (float)length);
    }

    private float meanDifference(float[] arr1, int i1, float[] arr2, int i2, int length) {
        float value = 0.0f;
        for (int i = 0; i < length; ++i) {
            value += arr1[i1 + i] - arr2[i2 + i];
        }
        return value / (float)length;
    }

    private float positiveMeanDifference(float[] arr1, int i1, float[] arr2, int i2, int length) {
        float value = 0.0f;
        for (int i = 0; i < length; ++i) {
            if (!(arr1[i1 + i] > arr2[i2 + i])) continue;
            value += arr1[i1 + i] - arr2[i2 + i];
        }
        return value / (float)length;
    }

    private void calcMaxAndMinBin(int blocksize) {
        this.minBin = Math.min(blocksize - 1, Math.max(0, Math.round(FFT.binNumber(this.sampleRate, blocksize, this.minFreq))));
        this.maxBin = Math.min(blocksize - 1, Math.max(0, Math.round(FFT.binNumber(this.sampleRate, blocksize, this.maxFreq))));
    }

    public static enum DifferenceType {
        POSITIVERMS,
        RMS,
        POSITIVEMEANDIFFERENCE,
        MEANDIFFERENCE;

    }
}

