/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioFileReader;
import beads.AudioFileType;
import beads.AudioFileWriter;
import beads.FileFormatException;
import beads.OperationUnsupportedException;
import beads.SampleAudioFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;

public class WavFileReaderWriter
implements AudioFileReader,
AudioFileWriter {
    private static final int BUFFER_SIZE = 4096;
    private static final int FMT_CHUNK_ID = 544501094;
    private static final int DATA_CHUNK_ID = 1635017060;
    private static final int RIFF_CHUNK_ID = 1179011410;
    private static final int RIFF_TYPE_ID = 1163280727;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_IEEE_FLOAT = 3;
    private File file;
    private int bytesPerSample;
    private long numFrames;
    private FileOutputStream oStream;
    private FileInputStream iStream;
    private double floatScale;
    private double floatOffset;
    private boolean wordAlignAdjust;
    private int numChannels;
    private long sampleRate;
    private int blockAlign;
    private int validBits;
    private int compressionCode;
    private byte[] buffer;
    private int bufferPointer;
    private int bytesRead;
    private long frameCounter;
    private IOState ioState = IOState.CLOSED;

    public WavFileReaderWriter() {
        this.buffer = new byte[4096];
    }

    @Override
    public void writeAudioFile(float[][] data, String filename, AudioFileType type, SampleAudioFormat saf) throws IOException, OperationUnsupportedException, FileFormatException {
        if (!this.getSupportedFileTypesForWriting().contains((Object)type)) {
            throw new OperationUnsupportedException("Unsupported file type for writing: " + (Object)((Object)type));
        }
        this.sampleRate = (long)saf.sampleRate;
        this.numChannels = data.length;
        this.validBits = saf.bitDepth;
        this.numFrames = data[0].length;
        this.file = new File(filename);
        this.ioState = IOState.WRITING;
        try {
            this.writeHeader();
            this.writeData(data);
            this.close();
        }
        catch (IOException e) {
            throw new IOException("Could not write audio file: " + e.getMessage());
        }
        catch (FileFormatException e) {
            throw new FileFormatException("Could not write audio file: " + e.getMessage());
        }
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForWriting() {
        HashSet<AudioFileType> types = new HashSet<AudioFileType>();
        types.add(AudioFileType.WAV);
        return types;
    }

    @Override
    public float[][] readAudioFile(String filename) throws IOException, OperationUnsupportedException, FileFormatException {
        if (!filename.endsWith(".wav") && !filename.endsWith(".WAV")) {
            throw new OperationUnsupportedException("Only wav files (ending in .wav or .WAV) are supported");
        }
        this.file = new File(filename);
        float[][] data = null;
        this.readHeader();
        data = this.readData();
        this.close();
        return data;
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForReading() {
        HashSet<AudioFileType> types = new HashSet<AudioFileType>();
        types.add(AudioFileType.WAV);
        return types;
    }

    @Override
    public SampleAudioFormat getSampleAudioFormat() {
        return new SampleAudioFormat(this.sampleRate, this.validBits, this.numChannels);
    }

    private void writeHeader() throws IOException, FileFormatException {
        this.bytesPerSample = (this.validBits + 7) / 8;
        this.blockAlign = this.bytesPerSample * this.numChannels;
        if (this.numChannels < 1 || this.numChannels > 65535) {
            throw new FileFormatException("Illegal number of channels, valid range 1 to 65536");
        }
        if (this.numFrames < 0L) {
            throw new FileFormatException("Number of frames must be positive");
        }
        if (this.validBits < 2 || this.validBits > 65535) {
            throw new FileFormatException("Illegal number of valid bits, valid range 2 to 65536");
        }
        if (this.sampleRate < 0L) {
            throw new FileFormatException("Sample rate must be positive");
        }
        this.compressionCode = this.validBits == 32 || this.validBits == 64 ? 3 : 1;
        this.oStream = new FileOutputStream(this.file);
        long dataChunkSize = (long)this.blockAlign * this.numFrames;
        int formatDataSize = this.compressionCode == 1 ? 16 : 18;
        long mainChunkSize = (long)(12 + formatDataSize + 8) + dataChunkSize;
        if (dataChunkSize % 2L == 1L) {
            ++mainChunkSize;
            this.wordAlignAdjust = true;
        } else {
            this.wordAlignAdjust = false;
        }
        WavFileReaderWriter.putLE(1179011410L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(mainChunkSize, this.buffer, 4, 4);
        WavFileReaderWriter.putLE(1163280727L, this.buffer, 8, 4);
        this.oStream.write(this.buffer, 0, 12);
        long averageBytesPerSecond = this.sampleRate * (long)this.blockAlign;
        WavFileReaderWriter.putLE(544501094L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(formatDataSize, this.buffer, 4, 4);
        WavFileReaderWriter.putLE(this.compressionCode, this.buffer, 8, 2);
        WavFileReaderWriter.putLE(this.numChannels, this.buffer, 10, 2);
        WavFileReaderWriter.putLE(this.sampleRate, this.buffer, 12, 4);
        WavFileReaderWriter.putLE(averageBytesPerSecond, this.buffer, 16, 4);
        WavFileReaderWriter.putLE(this.blockAlign, this.buffer, 20, 2);
        WavFileReaderWriter.putLE(this.validBits, this.buffer, 22, 2);
        if (this.compressionCode == 3) {
            WavFileReaderWriter.putLE(0L, this.buffer, 24, 2);
        }
        this.oStream.write(this.buffer, 0, 8 + formatDataSize);
        WavFileReaderWriter.putLE(1635017060L, this.buffer, 0, 4);
        WavFileReaderWriter.putLE(dataChunkSize, this.buffer, 4, 4);
        this.oStream.write(this.buffer, 0, 8);
        if (this.validBits > 8) {
            this.floatOffset = 0.0;
            this.floatScale = Long.MAX_VALUE >> 64 - this.validBits;
        } else {
            this.floatOffset = 1.0;
            this.floatScale = 0.5 * (double)((1 << this.validBits) - 1);
        }
        this.bufferPointer = 0;
        this.bytesRead = 0;
        this.frameCounter = 0L;
        this.ioState = IOState.WRITING;
    }

    private void writeData(float[][] data) throws IOException {
        int frameCounter = 0;
        int blockSize = 10000;
        while ((long)frameCounter < this.numFrames) {
            long remaining = this.getFramesRemaining();
            int toWrite = remaining > (long)blockSize ? blockSize : (int)remaining;
            this.writeFrames(data, frameCounter, toWrite);
            frameCounter += toWrite;
        }
    }

    private void readHeader() throws IOException, FileFormatException, OperationUnsupportedException {
        this.iStream = new FileInputStream(this.file);
        int bytesRead = this.iStream.read(this.buffer, 0, 12);
        if (bytesRead != 12) {
            throw new FileFormatException("Not enough wav file bytes for header");
        }
        long riffChunkID = WavFileReaderWriter.getLE(this.buffer, 0, 4);
        long chunkSize = WavFileReaderWriter.getLE(this.buffer, 4, 4);
        long riffTypeID = WavFileReaderWriter.getLE(this.buffer, 8, 4);
        if (riffChunkID != 1179011410L) {
            throw new FileFormatException("Invalid Wav Header data, incorrect riff chunk ID");
        }
        if (riffTypeID != 1163280727L) {
            throw new FileFormatException("Invalid Wav Header data, incorrect riff type ID");
        }
        if (this.file.length() != chunkSize + 8L) {
            throw new FileFormatException("Header chunk size (" + chunkSize + ") does not match file size (" + this.file.length() + ")");
        }
        boolean foundFormat = false;
        boolean foundData = false;
        while (true) {
            long numChunkBytes;
            if ((bytesRead = this.iStream.read(this.buffer, 0, 8)) == -1) {
                throw new FileFormatException("Reached end of file without finding format chunk");
            }
            if (bytesRead != 8) {
                throw new FileFormatException("Could not read chunk header");
            }
            long chunkID = WavFileReaderWriter.getLE(this.buffer, 0, 4);
            chunkSize = WavFileReaderWriter.getLE(this.buffer, 4, 4);
            long l = numChunkBytes = chunkSize % 2L == 1L ? chunkSize + 1L : chunkSize;
            if (chunkID == 544501094L) {
                foundFormat = true;
                bytesRead = this.iStream.read(this.buffer, 0, 16);
                int compressionCode = (int)WavFileReaderWriter.getLE(this.buffer, 0, 2);
                if (compressionCode != 1 && compressionCode != 3) {
                    throw new OperationUnsupportedException("Compression Code " + compressionCode + " not supported");
                }
                this.compressionCode = compressionCode;
                this.numChannels = (int)WavFileReaderWriter.getLE(this.buffer, 2, 2);
                this.sampleRate = WavFileReaderWriter.getLE(this.buffer, 4, 4);
                this.blockAlign = (int)WavFileReaderWriter.getLE(this.buffer, 12, 2);
                this.validBits = (int)WavFileReaderWriter.getLE(this.buffer, 14, 2);
                if (this.numChannels == 0) {
                    throw new FileFormatException("Number of channels specified in header is equal to zero");
                }
                if (this.blockAlign == 0) {
                    throw new FileFormatException("Block Align specified in header is equal to zero");
                }
                if (this.validBits < 2) {
                    throw new FileFormatException("Valid Bits specified in header is less than 2");
                }
                if (this.validBits > 64) {
                    throw new FileFormatException("Valid Bits specified in header is greater than 64, this is greater than a long can hold");
                }
                if (this.compressionCode == 3 && this.validBits != 32 && this.validBits != 64) {
                    throw new IOException("Only 32-bit and 64-bit Floating Point PCM files are supported");
                }
                this.bytesPerSample = (this.validBits + 7) / 8;
                if (this.bytesPerSample * this.numChannels != this.blockAlign) {
                    throw new FileFormatException("Block Align does not agree with bytes required for validBits and number of channels");
                }
                if ((numChunkBytes -= 16L) <= 0L) continue;
                this.iStream.skip(numChunkBytes);
                continue;
            }
            if (chunkID == 1635017060L) {
                if (!foundFormat) {
                    throw new FileFormatException("Data chunk found before Format chunk");
                }
                if (chunkSize % (long)this.blockAlign != 0L) {
                    throw new FileFormatException("Data Chunk size is not multiple of Block Align");
                }
                break;
            }
            this.iStream.skip(numChunkBytes);
        }
        this.numFrames = chunkSize / (long)this.blockAlign;
        foundData = true;
        if (!foundData) {
            throw new FileFormatException("Did not find a data chunk");
        }
        if (this.validBits > 8) {
            this.floatOffset = 0.0;
            this.floatScale = 1 << this.validBits - 1;
        } else {
            this.floatOffset = -1.0;
            this.floatScale = 0.5 * (double)((1 << this.validBits) - 1);
        }
        this.bufferPointer = 0;
        this.bytesRead = 0;
        this.frameCounter = 0L;
        this.ioState = IOState.READING;
    }

    private float[][] readData() throws IOException {
        float[][] data = new float[this.numChannels][(int)this.numFrames];
        long framesRead = 0L;
        int offset = 0;
        int blockSize = 10000;
        do {
            framesRead = this.readFrames(data, offset, blockSize);
            offset = (int)((long)offset + framesRead);
        } while (framesRead != 0L);
        return data;
    }

    private void close() throws IOException {
        if (this.iStream != null) {
            this.iStream.close();
            this.iStream = null;
        }
        if (this.oStream != null) {
            if (this.bufferPointer > 0) {
                this.oStream.write(this.buffer, 0, this.bufferPointer);
            }
            if (this.wordAlignAdjust) {
                this.oStream.write(0);
            }
            this.oStream.close();
            this.oStream = null;
        }
        this.ioState = IOState.CLOSED;
    }

    private int writeFrames(float[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample(Float.floatToIntBits(sampleBuffer[c][offset]));
                }
                ++offset;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample(Double.doubleToLongBits(sampleBuffer[c][offset]));
                }
                ++offset;
                ++this.frameCounter;
            }
        } else {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample((long)(this.floatScale * (this.floatOffset + (double)sampleBuffer[c][offset])));
                }
                ++offset;
                ++this.frameCounter;
            }
        }
        return numFramesToWrite;
    }

    private int writeFrames(double[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample(Float.floatToIntBits((float)sampleBuffer[c][offset]));
                }
                ++offset;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample(Double.doubleToLongBits(sampleBuffer[c][offset]));
                }
                ++offset;
                ++this.frameCounter;
            }
        } else {
            for (int f = 0; f < numFramesToWrite; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    this.writeSample((long)(this.floatScale * (this.floatOffset + sampleBuffer[c][offset])));
                }
                ++offset;
                ++this.frameCounter;
            }
        }
        return numFramesToWrite;
    }

    private void writeSample(long val) throws IOException {
        for (int b = 0; b < this.bytesPerSample; ++b) {
            if (this.bufferPointer == 4096) {
                this.oStream.write(this.buffer, 0, 4096);
                this.bufferPointer = 0;
            }
            this.buffer[this.bufferPointer] = (byte)(val & 0xFFL);
            val >>= 8;
            ++this.bufferPointer;
        }
    }

    private int readFrames(float[][] sampleBuffer, int offset, int numFramesToRead) throws IOException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = Float.intBitsToFloat((int)this.readSample());
                }
                ++offset;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = (float)Double.longBitsToDouble(this.readSample());
                }
                ++offset;
                ++this.frameCounter;
            }
        } else {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = (float)(this.floatOffset + (double)this.readSample() / this.floatScale);
                }
                ++offset;
                ++this.frameCounter;
            }
        }
        return numFramesToRead;
    }

    private int readFrames(double[][] sampleBuffer, int offset, int numFramesToRead) throws IOException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Incorrect IOState");
        }
        if (this.compressionCode == 3 && this.validBits == 32) {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = Float.intBitsToFloat((int)this.readSample());
                }
                ++offset;
                ++this.frameCounter;
            }
        } else if (this.compressionCode == 3 && this.validBits == 64) {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = Double.longBitsToDouble(this.readSample());
                }
                ++offset;
                ++this.frameCounter;
            }
        } else {
            for (int f = 0; f < numFramesToRead; ++f) {
                if (this.frameCounter == this.numFrames) {
                    return f;
                }
                for (int c = 0; c < this.numChannels; ++c) {
                    sampleBuffer[c][offset] = this.floatOffset + (double)this.readSample() / this.floatScale;
                }
                ++offset;
                ++this.frameCounter;
            }
        }
        return numFramesToRead;
    }

    private long readSample() throws IOException {
        long val = 0L;
        for (int b = 0; b < this.bytesPerSample; ++b) {
            if (this.bufferPointer == this.bytesRead) {
                int read = this.iStream.read(this.buffer, 0, 4096);
                if (read == -1) {
                    throw new IOException("Not enough data available");
                }
                this.bytesRead = read;
                this.bufferPointer = 0;
            }
            long v = this.buffer[this.bufferPointer];
            if (b < this.bytesPerSample - 1 || this.bytesPerSample == 1) {
                v &= 0xFFL;
            }
            val += v << b * 8;
            ++this.bufferPointer;
        }
        return val;
    }

    private long getFramesRemaining() {
        return this.numFrames - this.frameCounter;
    }

    private static long getLE(byte[] buffer, int pos, int numBytes) {
        long val = buffer[pos += --numBytes] & 0xFF;
        for (int b = 0; b < numBytes; ++b) {
            val = (val << 8) + (long)(buffer[--pos] & 0xFF);
        }
        return val;
    }

    private static void putLE(long val, byte[] buffer, int pos, int numBytes) {
        for (int b = 0; b < numBytes; ++b) {
            buffer[pos] = (byte)(val & 0xFFL);
            val >>= 8;
            ++pos;
        }
    }

    private static enum IOState {
        READING,
        WRITING,
        CLOSED;

    }
}

