
import beads.*;

AudioContext ac;

ArrayList<Spot> spots = new ArrayList<Spot>();
ArrayList<Route> routes = new ArrayList<Route>();
ArrayList<Popu> popus = new ArrayList<Popu>();

float totalDistance = 0;
float totalTime = 0;
float totalCarbon = 0;
float totalCarbonInterp = 0;
float budget = 1000;
float totalDiversity = 0;

float popularity = 4;
float artistCost = 0;
float artistCarbonCost = 0;

Spot lastSpot;

int phase = 0;
// 0 = intro ministre
// 1 = intro artiste
// 2 = make route
// 3 = choix ministre
// 4 = enfer

PImage[] ministresPic = new PImage[4];
PImage[] artistePic = new PImage[6];
PImage popu;

PImage map;

String[] spotsTxt;

float jaugeToSizeScale = 0.5;

ArrayList<String> coords = new ArrayList<String>();
boolean exportCoords = false;

PImage enfer;

SamplePlayer musicLoop;
SamplePlayer eventSfx;

PImage[] choicesM = new PImage[10];
int currentChoiceM = 0;
boolean popuHasMoved = false;
boolean nextRunDefined = false;

void setup() {
  // size(1000, 800);
  fullScreen();
  ministresPic[0]=loadImage(dataPath("jack.png"));
  ministresPic[1]=loadImage(dataPath("rachida.png"));
  ministresPic[2]=loadImage(dataPath("cyril.png"));
  ministresPic[3]=loadImage(dataPath("brigitte.png"));
  artistePic[0]=loadImage(dataPath("taylor.png"));
  artistePic[1]=loadImage(dataPath("buffalo.png"));
  artistePic[2]=loadImage(dataPath("bulg.png"));
  artistePic[3]=loadImage(dataPath("twende.png"));
  artistePic[4]=loadImage(dataPath("hamraj.png"));
  artistePic[5]=loadImage(dataPath("sababa5.png"));
  for (int i=0; i<choicesM.length; i++) choicesM[i]=loadImage(dataPath("event"+nf(i, 2)+".png"));
  popu=loadImage(dataPath("popu.png"));
  map=loadImage(dataPath("map01.png"));
  enfer = loadImage(dataPath("enfer01.jpg"));
  spotsTxt = loadStrings(dataPath("spots.txt"));

  ac = AudioContext.getDefaultContext();
  musicLoop = new SamplePlayer(SampleManager.sample(dataPath("Brego01.wav")));
  eventSfx = new SamplePlayer(SampleManager.sample(dataPath("pouet.wav")));
  Gain g = new Gain(1, 0.2);
  musicLoop.pause(true);
  eventSfx.pause(true);
  eventSfx.setKillOnEnd(false);
  g.addInput(eventSfx);
  g.addInput(musicLoop);
  ac.out.addInput(g);
  ac.start();

  init();
  /*
  for (int i=0; i<spots.size(); i++) {
   if (lastSpot==null) lastSpot = spots.get(i);
   if (spots.get(i).pos.y>lastSpot.pos.y) lastSpot = spots.get(i);
   }
   lastSpot.visited = true;
   */
}

void init() {
  totalDistance = 0;
  totalTime = 0;
  totalCarbon = 0;
  totalCarbonInterp = 0;
  budget = 1000;
  totalDiversity = 0;
  popularity = 4;
  artistCost = 0;
  artistCarbonCost = 0;

  popuHasMoved = false;
  nextRunDefined = false;

  spots = new ArrayList<Spot>();
  routes = new ArrayList<Route>();
  popus = new ArrayList<Popu>();
  int lineIndex = 12;
  while (lineIndex+10 < spotsTxt.length) {
    Spot s = new Spot(new PVector(Float.parseFloat(spotsTxt[lineIndex+1]), Float.parseFloat(spotsTxt[lineIndex+2])), Float.parseFloat(spotsTxt[lineIndex+4]));
    s.name = spotsTxt[lineIndex];
    s.description = spotsTxt[lineIndex+3];
    s.exclu = Integer.parseInt(spotsTxt[lineIndex+5]);
    s.carbon = Float.parseFloat(spotsTxt[lineIndex+6]);
    s.cout = Float.parseFloat(spotsTxt[lineIndex+7]);
    s.recette = Float.parseFloat(spotsTxt[lineIndex+8]);
    s.diversity = Float.parseFloat(spotsTxt[lineIndex+9]);
    spots.add(s);
    lineIndex += 11;
  }
  String[] popuCoordinates = loadStrings("popuCoordinates.txt");
  lineIndex = 0;
  while (lineIndex+1 < popuCoordinates.length) {
    popus.add(new Popu(new PVector(Float.parseFloat(popuCoordinates[lineIndex]), Float.parseFloat(popuCoordinates[lineIndex+1]))));
    lineIndex+=2;
  }
}

void draw() {
  if (phase==0) {
    background(0xFF);
    fill(0);
    textSize(50);
    text("Ministre...", 50, 100);
    for (int x=0; x<2; x++) {
      for (int y=0; y<2; y++) {
        pushMatrix();
        imageMode(CENTER);
        translate((x+1)*(float)width/3, (y+1)*(float)height/3);
        scale(3);
        image(ministresPic[x+y*2], 0, 0);
        popMatrix();
      }
    }
  } else if (phase==1) {
    background(0xFF);
    for (int x=0; x<3; x++) {
      for (int y=0; y<2; y++) {
        pushMatrix();
        imageMode(CENTER);
        translate((x+1)*(float)width/4, (y+1)*(float)height/3);
        scale(2);
        image(artistePic[x+y*3], 0, 0);
        popMatrix();
      }
    }
    if (mouseX<width*1/3&&mouseX>=width*0/3&&mouseY<height/2) {// taylor
      fill(0);
      textSize(50);
      text("Taylor Swift", 50, 100);
      text("grosse artiste", 50, 150);
    }
    if (mouseX<width*2/3&&mouseX>=width*1/3&&mouseY<height/2) {// buff
      fill(0);
      textSize(50);
      text("Buffalo Bill", 50, 100);
      text("travaille avec des artistes locaux, se déplace à cheval", 50, 150);
    }
    if (mouseX<width*3/3&&mouseX>=width*2/3&&mouseY<=height/2) {// bulg
      fill(0);
      textSize(50);
      text("Voix bulgares", 50, 100);
      text("se déplace en tour bus, équipe de vingt personnes", 50, 150);
    }
    if (mouseX<width*1/3&&mouseX>=width*0/3&&mouseY>=height/2) {// twende pamoja
      fill(0);
      textSize(50);
      text("Twende Pamoja", 50, 100);
      text("quatre personnes dont une en France, les trois autres doivent obtenir un visa", 50, 150);
    }
    if (mouseX<width*2/3&&mouseX>=width*1/3&&mouseY>=height/2) {// hamraj
      fill(0);
      textSize(50);
      text("Hamraj", 50, 100);
      text("iraniennes mais vivent en Europe, visa ok", 50, 150);
    }
    if (mouseX<width*3/3&&mouseX>=width*2/3&&mouseY>=height/2) {// sababa5
      fill(0);
      textSize(50);
      text("Sababa5", 50, 100);
      text("vivent en France, diaspora locale", 50, 150);
    }
  } else if (phase==2) {
    eventSfx.pause(true);
    // update
    popuHasMoved = false;
    for (Popu p : popus) p.update();
    totalCarbonInterp = lerp(totalCarbonInterp, totalCarbon, 0.5);
    // draw
    background(0xFF);
    imageMode(CORNER);
    image(map, 0, 0);
    for (Popu p : popus) p.draw();
    for (Spot s : spots) s.draw();
    for (Route r : routes) r.draw();
    for (Spot s : spots) s.drawTooltip();
    fill(0);
    textSize(20);
    text("distance : "+floor(totalDistance)+" km", 50, 50);
    text("temps : "+floor(totalTime)+" jours", 50, 80);
    text("carbone : "+floor(totalCarbonInterp)+" TeqCO2", 50, 110);
    text("budget : "+floor(budget)+" flouz", 50, 140);
    stroke(0);
    fill(0xFF);
    rect(300, 93, 1000, 20);
    noStroke();
    fill(0);
    rect(300, 93, totalCarbonInterp*1000/10, 20);
    if (totalCarbon*1000/10>1000) {
      phase=4;
      musicLoop.pause(true);
    }
    if (!popuHasMoved && nextRunDefined) {
      phase=3;
      musicLoop.pause(true);
      eventSfx.reset();
      eventSfx.pause(false);
    }
  } else if (phase==3) {
    imageMode(CENTER);
    image(choicesM[currentChoiceM], width/2, height/2);
  } else if (phase==4) {
    imageMode(CENTER);
    image(enfer, width/2, height/2, enfer.width*3, enfer.height*3);
  }
}

void mouseReleased() {
  if (exportCoords&&phase==2) {
    coords.add(str(mouseX));
    coords.add(str(mouseY));
    saveStrings("coordinates.txt", coords.toArray(new String[0]));
  }
  if (phase==0) {
    phase = 1;
  } else if (phase==1) {
    if (mouseX<width*1/3&&mouseX>=width*0/3&&mouseY<height/2) {// taylor
      lastSpot = new Spot(new PVector(-2000, 500), 1);
      artistCarbonCost=1;
      popularity=100;
      artistCost=1000;
      budget=2000;
    }
    if (mouseX<width*2/3&&mouseX>=width*1/3&&mouseY<height/2) {// buff
      lastSpot = new Spot(new PVector(-500, 500), 1);
      artistCarbonCost=0.1;
      popularity=75;
      artistCost=200;
      budget=1000;
    }
    if (mouseX<width*3/3&&mouseX>=width*2/3&&mouseY<=height/2) {// bulg
      lastSpot = new Spot(new PVector(1800, 1000), 1);
      artistCarbonCost=0.1;
      popularity=50;
      artistCost=750;
      budget=900;
    }
    if (mouseX<width*1/3&&mouseX>=width*0/3&&mouseY>=height/2) {// twende pamoja
      lastSpot = new Spot(new PVector(500, 2500), 1);
      artistCarbonCost=0.1;
      popularity=20;
      artistCost=400;
      budget=800;
    }
    if (mouseX<width*2/3&&mouseX>=width*1/3&&mouseY>=height/2) {// hamraj
      lastSpot = new Spot(new PVector(860, 250), 1);
      artistCarbonCost=0.1;
      popularity=20;
      artistCost=300;
      budget=700;
    }
    if (mouseX<width*3/3&&mouseX>=width*2/3&&mouseY>=height/2) {// sababa5
      lastSpot = new Spot(new PVector(650, 510), 1);
      artistCarbonCost=0.01;
      popularity=40;
      artistCost=300;
      budget=600;
    }
    phase = 3;
    nextRunDefined = false;
  } else if (phase==2) {
    if (nextRunDefined) return;
    boolean dateWasAdded = false;
    for (Spot s : spots) {
      if (dist(mouseX, mouseY, s.pos.x, s.pos.y)<s.jauge*jaugeToSizeScale/2) {
        if (!s.forbidden && !s.visited) {
          Route newRoute = new Route(lastSpot, s);
          routes.add(newRoute);
          lastSpot=s;
          lastSpot.visited = true;
          dateWasAdded = true;
          totalDistance += newRoute.getDistance();
          totalTime += (newRoute.getDistance()>200)?2:1;
          totalCarbon += newRoute.getDistance()/1000.0;
          totalCarbon += s.carbon/2.0;
          totalCarbon += artistCarbonCost;
          budget -= artistCost;
          budget += s.recette*20;
          budget -= s.cout*5;
          budget -= newRoute.getDistance()/100;
          totalDiversity += s.diversity;
        }
      }
    }
    if (dateWasAdded) {
      for (Spot s : spots) {
        if (s.exclu>0) {
          if (PVector.dist(lastSpot.pos, s.pos)<s.exclu*50) {
            s.forbidden = true;
          }
        }
      }

      float actualJauge = min(popularity, lastSpot.jauge);
      for (int i=0; i<actualJauge; i++) {
        Popu bestPopu = null;
        for (Popu p : popus) {
          if (!p.hasMoved) {
            if (bestPopu==null) bestPopu=p;
            if (PVector.dist(p.pos, lastSpot.pos)<PVector.dist(bestPopu.pos, lastSpot.pos)) {
              if (random(0.5) < 2.0/actualJauge) bestPopu = p;
            }
          }
        }
        if (bestPopu!=null) {
          bestPopu.target = lastSpot.pos;
          bestPopu.hasMoved = true;
        }
      }
      nextRunDefined = true;
    }
  } else if (phase==3) {
    musicLoop.pause(false);
    phase=2;
    nextRunDefined = false;
    currentChoiceM=(currentChoiceM+1)%choicesM.length;
    // if (random(1)<0.5) currentChoiceM=(currentChoiceM+1)%choicesM.length;
  } else if (phase==4) {
    init();
    phase=0;
  }
}

class Spot {
  PVector pos;
  float jauge;
  float carbon;
  float cout;
  float recette;
  int exclu=0;
  boolean visited = false;
  boolean forbidden  = false;
  String name;
  String description;
  float diversity;

  Spot(PVector pos, float jauge) {
    this.pos = pos.copy();
    this.jauge = jauge;
  }
  void draw() {
    stroke(0);
    fill(0xFF, 0xFF, 0x80);
    if (forbidden)  fill(0xFF, 0xA0, 0xA0);
    if (visited) fill(0xA0, 0xA0, 0xFF);
    ellipse(pos.x, pos.y, jauge*jaugeToSizeScale, jauge*jaugeToSizeScale);
    fill(0);
  }
  void drawTooltip() {
    if (dist(mouseX, mouseY, pos.x, pos.y) < jauge*jaugeToSizeScale/2) {
      stroke(0);
      fill(0xFF);
      rect(pos.x+20, pos.y+20, 500, 220);
      fill(0);
      text(name, pos.x+50, pos.y+50);
      text(description, pos.x+50, pos.y+90);
      text("capacité : "+jauge+" personnes", pos.x+50, pos.y+130);
      String recettesStars = "";
      for (int i=0; i<recette; i++) recettesStars+="$";
      text("recette : "+recettesStars, pos.x+50, pos.y+170);
      if (exclu>0) text("clause d'exclusivité sur "+(exclu*50)+" km", pos.x+50, pos.y+210);
    }
  }
}

class Route {
  Spot start;
  Spot stop;
  Route(Spot start, Spot stop) {
    this.start = start;
    this.stop = stop;
  }
  void draw() {
    stroke(0);
    fill(0xFF);
    float nbDivs = PVector.sub(stop.pos, start.pos).mag()/10.0;
    for (int i=0; i+1<nbDivs; i++) {
      float phaseA = ((float)i+((float)frameCount/100)%1)/nbDivs;
      float phaseB = ((float)i+0.5+((float)frameCount/100)%1)/nbDivs;
      line(lerp(start.pos.x, stop.pos.x, phaseA), lerp(start.pos.y, stop.pos.y, phaseA), lerp(start.pos.x, stop.pos.x, phaseB), lerp(start.pos.y, stop.pos.y, phaseB));
    }
  }
  float getDistance() {
    return PVector.sub(stop.pos, start.pos).mag();
  }
}

class Popu {
  PVector pos;
  PVector target;
  boolean hasMoved = false;
  Popu(PVector pos) {
    this.pos = pos;
    this.target = pos;
  }
  void update() {
    if (PVector.dist(pos, target)>1) {
      PVector direction = PVector.sub(target, pos);
      direction.normalize();
      pos.add(direction);
      totalCarbon+=0.1/1000.0;
      popuHasMoved=true;
    }
  }
  void draw() {
    imageMode(CENTER);
    image(popu, pos.x, pos.y);
  }
}

void keyPressed() {
  if (key=='m') {
    musicLoop.pause(true);
  }
}
