import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.io.*; 
import java.awt.FileDialog; 
import java.awt.Frame; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Perso extends PApplet {


int frameNb=0;

public void setup() {
  
}

public void draw() {
  if (frameNb%10==0) {
    background(0xFF);
    display(dataPath(""));
  }
  frameNb++;
}

public void display(String url) {
  String[] ins = getAllFilesFrom(url);
  if (ins.length>0) {
    if (ins[0].contains(".gif")||ins[0].contains(".png")) {
      String urlA = ins[floor(random(ins.length))];
      String urlB = urlA.substring(0, urlA.length()-3);
      if (urlA.contains(".gif")) urlB+="png";
      if (urlA.contains(".png")) urlB+="gif";
      if (urlA.contains(".gif")) image(loadImage(urlA), 0, 0);
      try {
        image(loadImage(urlB), 0, 0);
      } 
      catch(Exception e) {
        println("imgB "+e);
      }
      if (urlA.contains(".png")) image(loadImage(urlA), 0, 0);
    } else {
      if (ins[0].substring(ins[0].length()-6, ins[0].length()).contains("alt")) {
        String in = ins[floor(random(ins.length))];
        if (!in.contains("Thumbs.db")) display(in);
      } else {
        for (String in : ins) if (!in.contains("Thumbs.db")) display(in);
      }
    }
  }
}





public float vrMax(float a, float b, float m) {
  float d1=b-a;
  if (d1>m/2) {
    d1=d1-m;
  }
  if (d1<-m/2) {
    d1=d1+m;
  }
  return d1;
}

public String getDialogFileUrl(String label) {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, label, FileDialog.LOAD);
  fileDialog.setVisible(true);
  if (fileDialog.getFile()!=null) {
    String filePath = fileDialog.getDirectory() + fileDialog.getFile();
    return filePath;
  }
  return null;
}

public String getDialogFolderUrl(String label) {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, label, FileDialog.LOAD);
  fileDialog.setVisible(true);
  return fileDialog.getDirectory();
}

public String[] getDialogAllFilesUrl(String label) {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, label, FileDialog.LOAD);
  fileDialog.setVisible(true);
  return getAllFilesFrom(fileDialog.getDirectory());
}

public String[] getAllFilesFrom(String folderUrl) {
  File folder = new File(folderUrl);
  File[] filesPath = folder.listFiles();
  if (filesPath==null) {
    return new String[0];
  }
  String[] result = new String[filesPath.length];
  for (int i=0; i<filesPath.length; i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}

public void renameFile(String urlA, String urlB) {
  File file = new File(sketchPath(urlA));
  File file2 = new File(sketchPath(urlB));  
  boolean success = file.renameTo(file2);
  if (!success) {
    println(urlA + " was not renamed to " + urlB);
  }
}

public void copyDirectory(String urlA, String urlB) throws IOException {
  File srcDir = new File(sketchPath(urlA));
  File dstDir = new File(sketchPath(urlB));  
  try {
    copyDirectoryRec(srcDir, dstDir);
  } 
  catch (IOException e) {
    e.printStackTrace();
  }
}

public void copyDirectoryRec(File srcDir, File dstDir) throws IOException {
  // Copies all files under srcDir to dstDir.
  // If dstDir does not exist, it will be created.
  if (srcDir.isDirectory()) {
    if (!dstDir.exists()) {
      dstDir.mkdir();
    }
    String[] children = srcDir.list();
    for (int i=0; i<children.length; i++) {
      copyDirectoryRec(new File(srcDir, children[i]), new File(dstDir, children[i]));
    }
  } else {
    // This method is implemented in Copying a File
    copyFile(srcDir, dstDir);
  }
}

public void copyFile(File src, File dst) throws IOException {
  // Copies src file to dst file.
  // If the dst file does not exist, it is created
  InputStream in = new FileInputStream(src);
  OutputStream out = new FileOutputStream(dst);

  // Transfer bytes from in to out
  byte[] buf = new byte[1024];
  int len;
  while ( (len = in.read (buf)) > 0) {
    out.write(buf, 0, len);
  }
  in.close();
  out.close();
}
  public void settings() {  size(450, 600); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Perso" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
