/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import sojamo.drop.DropEvent;
import sojamo.drop.SDrop;

public class sketch_080518b
extends PApplet {
    private static final long serialVersionUID = 1L;
    SDrop drop;
    int nbTiles = 1000;
    int nbCTiles = 0;
    PImage[] tiles = new PImage[this.nbTiles];
    PFont font;
    int tX = 0;
    int tY = 0;
    boolean vert = true;
    boolean infos = true;
    boolean resiz = false;
    int maxH;
    int maxV;
    int hor;
    int ver;
    int pxHor;
    int pxVer;
    int totalpx;
    int prevtotalpx;
    int besti;
    int bgd = this.color(23, 123, 90);
    float infosX;
    float infosY;
    float infosTX;
    float infosTY;
    float infosM = 10.0f;
    boolean limitTo1024 = false;
    String message = "";
    static Vector<String> file = new Vector();

    @Override
    public void setup() {
        this.size(500, 500);
        this.drop = new SDrop(this);
        this.font = this.loadFont("PixelYourLife-10.vlw");
        this.textFont(this.font, 10.0f);
        this.infosX = this.width - 250;
        this.infosTX = 230.0f;
        this.infosY = 20.0f;
        this.infosTY = 300.0f;
        this.filesFromCL();
    }

    @Override
    public void draw() {
        this.background(this.bgd);
        if (this.nbCTiles > 0) {
            this.afficheTiles();
        }
        if (this.infos) {
            this.infos();
        }
    }

    public void infos() {
        this.noStroke();
        this.fill(255, 192.0f);
        this.rect(this.infosX, this.infosY, this.infosTX, this.infosTY);
        this.fill(0, 192.0f);
        this.text("Drag & drop png tiles in this window.", this.infosX + this.infosM, this.infosY + this.infosM + 0.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("CTRL changes the background color.", this.infosX + this.infosM, this.infosY + this.infosM + 30.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("SHIFT outputs the result.", this.infosX + this.infosM, this.infosY + this.infosM + 60.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("TAB closes these informations.", this.infosX + this.infosM, this.infosY + this.infosM + 90.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("BACKSPACE resizes the image on screen.", this.infosX + this.infosM, this.infosY + this.infosM + 120.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("ENTER switches between horizontal and vertical mode.", this.infosX + this.infosM, this.infosY + this.infosM + 150.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("The red lines represent the next powers of two.", this.infosX + this.infosM, this.infosY + this.infosM + 180.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text("UP limit to 1024 px.", this.infosX + this.infosM, this.infosY + this.infosM + 210.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
        this.text(this.message, this.infosX + this.infosM, this.infosY + this.infosM + 240.0f, this.infosTX - 2.0f * this.infosM, this.infosTY - 2.0f * this.infosM);
    }

    public void dropEvent(DropEvent theDropEvent) {
        this.tiles[this.nbCTiles] = this.loadImage(theDropEvent.filePath());
        if (this.tiles[this.nbCTiles].width > this.tX) {
            this.tX = this.tiles[this.nbCTiles].width;
        }
        if (this.tiles[this.nbCTiles].height > this.tY) {
            this.tY = this.tiles[this.nbCTiles].height;
        }
        ++this.nbCTiles;
        this.placeTiles();
    }

    public void filesFromCL() {
        int i = 0;
        while (i < file.size()) {
            this.tiles[this.nbCTiles] = this.loadImage(file.get(i));
            if (this.tiles[this.nbCTiles].width > this.tX) {
                this.tX = this.tiles[this.nbCTiles].width;
            }
            if (this.tiles[this.nbCTiles].height > this.tY) {
                this.tY = this.tiles[this.nbCTiles].height;
            }
            ++this.nbCTiles;
            ++i;
        }
        if (file.size() > 0) {
            this.placeTiles();
        }
    }

    public void placeTiles() {
        this.maxH = sketch_080518b.floor(sketch_080518b.sqrt(this.nbCTiles));
        this.prevtotalpx = 0;
        this.besti = 1;
        if (this.limitTo1024) {
            this.message = "size > 1024";
            boolean found = false;
            int i = 1;
            while (i <= this.nbCTiles && !found) {
                this.computeSize(i);
                if (this.pxHor <= 1024 && this.pxVer <= 1024) {
                    this.besti = i;
                    this.prevtotalpx = this.totalpx = this.pxHor * this.pxVer;
                    this.message = "size ok";
                    found = true;
                }
                ++i;
            }
        }
        int i = 1;
        while (i <= this.maxH) {
            this.computeSize(i);
            this.totalpx = this.pxHor * this.pxVer;
            boolean pxLimitation = false;
            if (this.limitTo1024 && (this.pxHor > 1024 || this.pxVer > 1024)) {
                pxLimitation = true;
            }
            if (this.totalpx <= this.prevtotalpx && !pxLimitation) {
                this.besti = i;
                this.prevtotalpx = this.totalpx;
                if (this.limitTo1024) {
                    this.message = "size ok";
                }
            }
            if (i == 1) {
                this.prevtotalpx = this.totalpx;
            }
            ++i;
        }
        this.computeSize(this.besti);
    }

    public void computeSize(int i) {
        if (this.vert) {
            this.hor = i;
            this.ver = sketch_080518b.ceil((float)this.nbCTiles / (float)this.hor);
        } else {
            this.ver = i;
            this.hor = sketch_080518b.ceil((float)this.nbCTiles / (float)this.ver);
        }
        this.pxHor = this.hor * this.tX;
        this.pxVer = this.ver * this.tY;
        this.pxHor = this.closePowTwo(this.pxHor);
        this.pxVer = this.closePowTwo(this.pxVer);
    }

    public int closePowTwo(int px) {
        boolean ok = false;
        int i = 0;
        while (!ok) {
            if ((float)px <= sketch_080518b.pow(2.0f, i) && (float)px > sketch_080518b.pow(2.0f, i - 1)) {
                px = (int)sketch_080518b.pow(2.0f, i);
                ok = true;
            }
            ++i;
        }
        return px;
    }

    public void afficheTiles() {
        this.pushMatrix();
        if (this.resiz) {
            float dezoom = sketch_080518b.min(sketch_080518b.min((float)(this.width - 2) / (float)this.pxHor, (float)(this.height - 2) / (float)this.pxVer), 1.0f);
            this.scale(dezoom, dezoom);
        }
        int i = 0;
        while (i < this.nbCTiles) {
            int x = i % this.hor;
            int y = sketch_080518b.floor(i / this.hor);
            this.image(this.tiles[i], this.tX * x, this.tY * y);
            ++i;
        }
        this.stroke(255.0f, 0.0f, 0.0f);
        this.line(0.0f, this.pxVer, this.pxHor, this.pxVer);
        this.line(this.pxHor, 0.0f, this.pxHor, this.pxVer);
        this.popMatrix();
    }

    @Override
    public void keyPressed() {
        if (this.keyCode == 16) {
            if (this.nbCTiles > 0) {
                PImage total = this.createImage(this.hor * this.tX, this.ver * this.tY, 2);
                int i = 0;
                while (i < this.nbCTiles) {
                    int x = i % this.hor;
                    int y = sketch_080518b.floor(i / this.hor);
                    int x2 = 0;
                    while (x2 < this.tX) {
                        int y2 = 0;
                        while (y2 < this.tY) {
                            total.set(x * this.tX + x2, y * this.tY + y2, this.tiles[i].get(x2, y2));
                            ++y2;
                        }
                        ++x2;
                    }
                    ++i;
                }
                total.save("Output.png");
            }
        } else if (this.keyCode == 17) {
            this.bgd = this.color(this.random(256.0f), this.random(256.0f), this.random(256.0f));
        } else if (this.keyCode == 9) {
            this.infos = !this.infos;
        } else if (this.keyCode == 8) {
            this.resiz = !this.resiz;
        } else if (this.keyCode == 10 || this.keyCode == 13) {
            this.vert = !this.vert;
            this.placeTiles();
        } else if (this.keyCode == 38) {
            this.limitTo1024 = true;
        }
    }

    private static void setFilesToUse(String[] args) {
        int i2 = 0;
        while (i2 < args.length) {
            file.add(args[i2]);
            ++i2;
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            sketch_080518b.setFilesToUse(args);
        }
        PApplet.main(new String[]{"sketch_080518b"});
    }
}

