/*
 * Decompiled with CFR 0.152.
 */
package sojamo.drop;

import java.awt.Component;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Vector;
import processing.core.PImage;
import sojamo.drop.DropImageReader;
import sojamo.drop.SDrop;

public class DropEvent {
    private boolean isFile = false;
    private boolean isImage = false;
    private boolean isURL = false;
    private File _myFile;
    private String _myURL = "";
    private String _myFilePath = "";
    private String _myString = "";
    SDrop drop;
    protected DropTargetDropEvent _myDropTargetDropEvent;
    protected final Component _myComponent;
    protected final DropTargetDropEvent _myEvent;

    protected DropEvent(SDrop sDrop, DropTargetDropEvent dropTargetDropEvent) {
        this._myEvent = dropTargetDropEvent;
        this.drop = sDrop;
        this._myComponent = dropTargetDropEvent.getDropTargetContext().getComponent();
    }

    public String toString() {
        if (this._myFilePath.length() > 0) {
            return this._myFilePath;
        }
        return this._myString;
    }

    public Component component() {
        return this._myComponent;
    }

    public int x() {
        return (int)this._myEvent.getLocation().getX();
    }

    public int y() {
        return (int)this._myEvent.getLocation().getY();
    }

    protected void setFile(File file) {
        String string;
        this._myFile = file;
        boolean bl = this.isFile = this._myFile != null;
        if (this._myFile != null) {
            this._myFilePath = this._myFile.getAbsolutePath();
        }
        if ((string = file.toString().toLowerCase()).toString().endsWith(".jpg") || string.toString().endsWith(".jpeg") || string.toString().endsWith(".gif") || string.toString().endsWith(".png")) {
            this.isImage = true;
        }
    }

    protected void setURL(String string) {
        this.isURL = true;
        this._myURL = string;
    }

    protected void setText(String string) {
        this._myString = string;
    }

    protected void setImage(boolean bl) {
        this.isImage = bl;
    }

    protected void setDropEvent(DropTargetDropEvent dropTargetDropEvent) {
        this._myDropTargetDropEvent = dropTargetDropEvent;
    }

    public DropTargetDropEvent dropTargetDropEvent() {
        return this._myDropTargetDropEvent;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isImage() {
        return this.isImage;
    }

    public boolean isURL() {
        return this.isURL;
    }

    public String text() {
        return this._myString;
    }

    public File file() {
        return this._myFile;
    }

    public String url() {
        return this._myURL;
    }

    public String filePath() {
        return this._myFilePath;
    }

    protected void process(DropImageReader dropImageReader) {
        dropImageReader.dispose();
        dropImageReader = null;
        this.process();
    }

    protected void process() {
        this.drop.invokeDropEvent(this);
    }

    protected PImage loadImageFromDisk() {
        String string = this.file().toString().toLowerCase();
        if (string.startsWith("http://") || string.startsWith("https://")) {
            this._myURL = this.file().toString();
            return this.loadImageFromURL();
        }
        PImage pImage = new PImage(1, 1);
        new DropImageReader(this, pImage, this.file().toString());
        return pImage;
    }

    protected PImage loadImageFromURL() {
        PImage pImage = new PImage(1, 1);
        new DropImageReader(this, pImage, this.url());
        return pImage;
    }

    protected PImage loadImageFromURL(PImage pImage) {
        if (pImage == null) {
            pImage = new PImage(1, 1);
        }
        new DropImageReader(this, pImage, this.url());
        return pImage;
    }

    public PImage loadImage() {
        if (this.isImage()) {
            if (this.isURL()) {
                return this.loadImageFromURL();
            }
            return this.loadImageFromDisk();
        }
        return null;
    }

    public static File[] listFilesAsArray(File file, FilenameFilter filenameFilter, boolean bl) {
        Collection collection = DropEvent.listFiles(file, filenameFilter, bl);
        File[] fileArray = new File[collection.size()];
        return collection.toArray(fileArray);
    }

    public static File[] listFilesAsArray(File file, boolean bl) {
        return DropEvent.listFilesAsArray(file, null, bl);
    }

    public static File[] listFilesAsArray(File file, FilenameFilter filenameFilter, int n) {
        Collection collection = DropEvent.listFiles(file, filenameFilter, n);
        File[] fileArray = new File[collection.size()];
        return collection.toArray(fileArray);
    }

    public static File[] listFilesAsArray(File file, int n) {
        return DropEvent.listFilesAsArray(file, null, n);
    }

    public static Collection listFiles(File file, FilenameFilter filenameFilter, boolean bl) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (filenameFilter == null || filenameFilter.accept(file, file2.getName())) {
                vector.add(file2);
            }
            if (!bl || !file2.isDirectory()) continue;
            vector.addAll(DropEvent.listFiles(file2, filenameFilter, bl));
        }
        return vector;
    }

    public static Collection listFiles(File file, boolean bl) {
        return DropEvent.listFiles(file, null, bl);
    }

    public static Collection listFiles(File file, FilenameFilter filenameFilter, int n) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (filenameFilter == null || filenameFilter.accept(file, file2.getName())) {
                vector.add(file2);
            }
            if (n <= 0 || !file2.isDirectory()) continue;
            vector.addAll(DropEvent.listFiles(file2, filenameFilter, --n));
            ++n;
        }
        return vector;
    }

    public static Collection listFiles(File file, int n) {
        return DropEvent.listFiles(file, null, n);
    }
}

