<?php

	function deleteNode($node) {
		deleteChildren($node);
		$parent = $node->parentNode;
		$oldnode = $parent->removeChild($node);
	}

	function deleteChildren($node) {
		while (isset($node->firstChild)) {
			deleteChildren($node->firstChild);
			$node->removeChild($node->firstChild);
		}
	}

	if (isset($_POST['index'])) $index = $_POST['index'];
	if (isset($_POST['year'])) $year = $_POST['year'];
	if (isset($_POST['month'])) $month = $_POST['month'];
	if (isset($_POST['day'])) $day = $_POST['day'];
	if (isset($_POST['postDate'])) $postDate = $_POST['postDate'];
	if (isset($_POST['text'])) $text = $_POST['text'];
	if (isset($_POST['tags'])) $tags = $_POST['tags'];

	$newImageName = "";
	if ($_FILES["file"]["name"]!="") {
		if ($_FILES["file"]["error"] > 0) {
			echo "Error : " . $_FILES["file"]["error"];
		} else {
			$blacklist = array(".php", ".phtml", ".php2", ".php3", ".php4", ".php", ".js", ".shtml", ".pl" , ".py", ".html");
			$forbidden = false;
			foreach ($blacklist as $black) {
				if(preg_match("/$black\$/i", $_FILES["file"]["name"])) {
					$forbidden = true;
				}
			}
			if (!$forbidden) {
				$newImageName = uniqid() . substr($_FILES["file"]["name"],strrpos($_FILES["file"]["name"],"."));
				move_uploaded_file($_FILES["file"]["tmp_name"],	'../pictures/' . $newImageName);
			}
		}
	}
	
	$xml = "../poubelles.xml";
	$doc = new DOMDocument('1.0', 'utf-8');
	$doc->formatOutput = true;
	$doc->preserveWhiteSpace = false;
	$doc->Load($xml);
	
	$poubelles = $doc->getElementsByTagName('poubelle');

	$found=false;
	for ($i=0 ; $i<$poubelles->length ; $i++) {
		if ($poubelles->item($i)->getAttribute('index')==$index) {
			$found=true;
			$poubelles->item($i)->setAttribute('year',$year);
			$poubelles->item($i)->setAttribute('month',$month);
			$poubelles->item($i)->setAttribute('day',$day);
			$poubelles->item($i)->setAttribute('postDate',$postDate);
			$poubelles->item($i)->getElementsByTagName('text')->item(0)->nodeValue = $text;
			if ($poubelles->item($i)->getElementsByTagName('tags')->length>0) deleteNode($poubelles->item($i)->getElementsByTagName('tags')->item(0));
			$tagsNode = $doc->createElement("tags");
			$tagsArray = explode(',',$tags);
			for ($j=0;$j<count($tagsArray);$j++) {
				while (substr($tagsArray[$j],0,1)==" ")  $tagsArray[$j]=substr($tagsArray[$j],1);
				while (substr($tagsArray[$j],-1,1)==" ") $tagsArray[$j]=substr($tagsArray[$j],0,strlen($tagsArray[$j])-1);
				if (strlen($tagsArray[$j])>0) {
					$tagNode = $doc->createElement("tag",$tagsArray[$j]);
					$tagsNode->appendChild($tagNode);
				}
			}
			$poubelles->item($i)->appendChild($tagsNode);			
			if ($_FILES["file"]["name"]!="") {
				$picture = $doc->createElement("picture");
				$picture->setAttribute('fileName',$newImageName);
				$poubelles->item($i)->getElementsByTagName('pictures')->item(0)->appendChild($picture);
			}
		}
	}

	if (!$found) {
		$poubelle = $doc->createElement("poubelle");
		$poubelle->setAttribute('index',$index);
		$poubelle->setAttribute('year',$year);
		$poubelle->setAttribute('month',$month);
		$poubelle->setAttribute('day',$day);
		$poubelle->setAttribute('postDate',$postDate);
		$textNode = $doc->createElement("text", $text);
		$poubelle->appendChild($textNode);
		$tagsNode = $doc->createElement("tags");
		$tagsArray = explode(',',$tags);
		for ($i=0;$i<count($tagsArray);$i++) {
			while (substr($tagsArray[$i],0,1)==" ")  $tagsArray[$i]=substr($tagsArray[$i],1);
			while (substr($tagsArray[$i],-1,1)==" ") $tagsArray[$i]=substr($tagsArray[$i],0,strlen($tagsArray[$i])-1);
			$tagNode = $doc->createElement("tag",$tagsArray[$i]);
			$tagsNode->appendChild($tagNode);
		}
		$poubelle->appendChild($tagsNode);
		$pictures = $doc->createElement("pictures");
		if ($_FILES["file"]["name"]!="") {
			$picture = $doc->createElement("picture");
			$picture->setAttribute('fileName',$newImageName);
			$pictures->appendChild($picture);
		}
		$poubelle->appendChild($pictures);
		$doc->documentElement->appendChild($poubelle);
	}
	
	$doc->formatOutput = true;		
	$doc->saveXML();
	$doc->save($xml);
	$doc->save("backups/" . date(c) . ".xml");	
	
	header('Location: index.php?index=' . $index);
	
?>
