﻿<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
</head>
<body bgcolor=#C3C3C3>

<?php

	mb_internal_encoding("UTF-8");
	
	$xml = "../poubelles.xml";
	$doc = new DOMDocument('1.0', 'utf-8');
	$doc->formatOutput = true;
	$doc->preserveWhiteSpace = false;
	$doc->Load($xml);

	$poubelles = $doc->getElementsByTagName('poubelle');

	$firstFreeId = -1;
	$found = true;
	while ($found) {
		$firstFreeId++;
		$found=false;
		for ($i=0; $i<$poubelles->length && !$found; $i++) {
			if ($poubelles->item($i)->getAttribute('index')==$firstFreeId) $found=true;
		}
	}

	if (isset($_GET['index'])) $currentIndex = $_GET['index'];
	else $currentIndex = $firstFreeId;
	
	if ($currentIndex == $firstFreeId) {
		$currentYear = date(Y);
		$currentMonth = date(m);
		$currentDay = date(d);
		$currentPostDate = date(c);
		$currentText = "";
		$currentTags = "";
		$currentPictures = array();
	} else {
		for ($i=0; $i<$poubelles->length; $i++) {
			if ($poubelles->item($i)->getAttribute('index') == $currentIndex) {
				$currentYear = $poubelles->item($i)->getAttribute('year');
				$currentMonth = $poubelles->item($i)->getAttribute('month');
				$currentDay = $poubelles->item($i)->getAttribute('day');
				$currentPostDate = $poubelles->item($i)->getAttribute('postDate');
				$currentText = $poubelles->item($i)->getElementsByTagName('text')->item(0)->nodeValue;
				$currentTags = array();
				if ($poubelles->item($i)->getElementsByTagName('tags')->length > 0) {
					$tags = $poubelles->item($i)->getElementsByTagName('tags')->item(0)->getElementsByTagName('tag');
					for ($j=0; $j<$tags->length ; $j++) $currentTags[] = $tags->item($j)->nodeValue;
				}
				$currentPictures = array();
				if ($poubelles->item($i)->getElementsByTagName('pictures')->length > 0) {
					$pictures = $poubelles->item($i)->getElementsByTagName('pictures')->item(0)->getElementsByTagName('picture');
					for ($j=0; $j<$pictures->length ; $j++) $currentPictures[] = $pictures->item($j)->getAttribute('fileName');
				}
			}
		}
	}

	echo '<div align="center">';
	
	echo '<form name="poubelle" action="addPost.php" method="post" enctype="multipart/form-data">';
	echo 'index : ' . '<input type="text" name="index" value="' . $currentIndex . '" />' . '<br/>';
	echo 'year : ' . '<input type="text" name="year" value="' . $currentYear . '" />' . '<br/>';
	echo 'month : ' . '<input type="text" name="month" value="' . $currentMonth . '" />' . '<br/>';
	echo 'day : ' . '<input type="text" name="day" value="' . $currentDay . '" />' . '<br/>';
	echo 'postDate : ' . '<input type="text" name="postDate" value="' . $currentPostDate . '" size=50 />' . '<br/>';
	echo 'text : ' . '<textarea cols="40" rows="5" name="text" />' . $currentText . '</textarea><br/>';
	echo 'tags : ' . '<textarea cols="40" rows="3" name="tags" />';
	for ($i=0 ; $i<count($currentTags) ; $i++) {
		echo $currentTags[$i];
		if ($i<count($currentTags)-1) echo ", ";
	}
	echo '</textarea><br/>';
	for ($i=0 ; $i<count($currentPictures) ; $i++) {
		echo '<img src="../pictures/' . $currentPictures[$i] . '" width=200px /> ';
		echo '<a href="deleteFile.php?index=' . $currentIndex . '&file=' . $currentPictures[$i] . '">delete</a><br/>';
	}
	echo '<input type="file" name="file" id="file"/><br/>';	
	echo '<input type="submit" value="Ok" />';
	echo '</form>';

	echo '<a href="updateRss.php">update RSS</a><br/>';
	echo '<br/>';
	echo '<a href="?">new</a><br/>';
	echo '<br/>';
	
	echo '<table>';
	for ($i=0; $i<$poubelles->length ; $i++) {
		echo '<tr><td>';
		echo '<a href="?index=' . $poubelles->item($i)->getAttribute('index') . '">';
		echo $poubelles->item($i)->getAttribute('index') . ' : ';
		echo $poubelles->item($i)->getAttribute('year') . ' / ';
		echo $poubelles->item($i)->getAttribute('month') . ' / ';
		echo $poubelles->item($i)->getAttribute('day') . ' / ';
		$text = $poubelles->item($i)->getElementsByTagName('text')->item(0)->nodeValue;
		echo mb_substr($text,0,21);
		echo '</a>';
		echo '</td><td>';
		echo '<a href=deletePost.php?index=' . $poubelles->item($i)->getAttribute('index') . '>delete</a>';
		echo '</td>';
		echo '</tr>';
	}
	echo '</table>';

	echo '</div>';

?>

</body>
<html>
