<?php

	function isoTimeToStamp($iso) {
		sscanf($iso,"%4u-%u-%uT%u:%2u:%2uZ",$annee,$mois,$jour,$heure,$minute,$seconde);
		$newTstamp = mktime($heure,$minute,$seconde,$mois,$jour,$annee);
		return $newTstamp+3600;
	}

	$xml = "../poubelles.xml";
	$doc = new DOMDocument('1.0', 'utf-8');
	$doc->formatOutput = true;
	$doc->preserveWhiteSpace = false;
	$doc->Load($xml);
	
	$poubelles = $doc->getElementsByTagName('poubelle');

	$rssDoc = new DOMDocument('1.0', 'utf-8');	
	$rssDoc->formatOutput = true;
	$rssDoc->preserveWhiteSpace = false;

	$channel = $rssDoc->createElement("channel");
	
	$title = $rssDoc->createElement("title",utf8_encode("Ce que j'ai jet  la poubelle"));
	$link = $rssDoc->createElement("link",utf8_encode("http://poubelles.nurykabe.com"));
	$description = $rssDoc->createElement("description",utf8_encode("Ce que j'ai jet  la poubelle"));

	$channel->appendChild($title);
	$channel->appendChild($link);
	$channel->appendChild($description);

	$atomLink = $rssDoc->createElement("atom:link");
	$atomLink->setAttribute("href","http://www.nurykabe.com/pages/poubelles/rss.xml");
	$atomLink->setAttribute("rel","self");
	$atomLink->setAttribute("type","application/rss+xml");
	$channel->appendChild($atomLink);
	
	for ($i=0 ; $i<$poubelles->length ; $i++) {
	
		$thisPermLink = utf8_encode("http://poubelles.nurykabe.com?seePost=" . $poubelles->item($i)->getAttribute('index'));
		
		$title = $rssDoc->createElement("title",utf8_encode(
			"jet le " . 
			$poubelles->item($i)->getAttribute('year') . "/" .
			$poubelles->item($i)->getAttribute('month') . "/" .
			$poubelles->item($i)->getAttribute('day') 
		));
		$link = $rssDoc->createElement("link",$thisPermLink);
		$guid = $rssDoc->createElement("guid",$thisPermLink);
		$descriptionValue = $poubelles->item($i)->getElementsByTagName('text')->item(0)->nodeValue;
		if ($poubelles->item($i)->getElementsByTagName('pictures')->item(0)->getElementsByTagName('picture')->length>0) {
			$descriptionValue .= '<img src="' . $poubelles->item($i)->getElementsByTagName('pictures')->item(0)->getElementsByTagName('picture')->item(0)->getAttribute('fileName') . '" />';
		}
		$description = $rssDoc->createElement("description",$descriptionValue);
		
		$thisDate = date(r,isoTimeToStamp($poubelles->item($i)->getAttribute('postDate')));
		
		$pubDate = $rssDoc->createElement("pubDate",$thisDate);

		$guid->setAttribute("isPermaLink","true");
		
		$item = $rssDoc->createElement("item");
		$item->appendChild($title);
		$item->appendChild($link);
		$item->appendChild($guid);
		$item->appendChild($description);
		$item->appendChild($pubDate);
		
		$channel->appendChild($item);
	}
	
	$rss = $rssDoc->createElement("rss");
	$rss->setAttribute("version","2.0");
	$rss->setAttribute("xmlns:atom","http://www.w3.org/2005/Atom");
	$rss->appendChild($channel);
	
	$rssDoc->appendChild($rss);
	
	$rssDoc->saveXML();
	$rssDoc->save("../rss.xml");
	
	header('Location: index.php');
	
?>
